/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.interfaces.IRadiationImmune;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.AdvancementManager;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityUFO
extends EntityFlying
implements IMob,
IRadiationImmune {
    public static final DataParameter<Boolean> BEAM = EntityDataManager.func_187226_a(EntityUFO.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<BlockPos> WAYPOINT = EntityDataManager.func_187226_a(EntityUFO.class, (DataSerializer)DataSerializers.field_187200_j);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
    public int courseChangeCooldown;
    public int scanCooldown;
    public int hurtCooldown;
    public int beamTimer;
    private Entity target;
    private List<Entity> secondaries = new ArrayList<Entity>();

    public EntityUFO(World p_i1587_1_) {
        super(p_i1587_1_);
        this.func_70105_a(15.0f, 4.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 500;
        this.field_70158_ak = true;
        this.field_70725_aQ = -30;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.hurtCooldown > 0) {
            return false;
        }
        boolean hit = super.func_70097_a(source, amount);
        if (hit) {
            this.hurtCooldown = 5;
        }
        return hit;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20000.0);
    }

    protected void func_70619_bc() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
                return;
            }
            if (this.hurtCooldown > 0) {
                --this.hurtCooldown;
            }
        }
        if (this.courseChangeCooldown > 0) {
            --this.courseChangeCooldown;
        }
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.target != null && !this.target.func_70089_S()) {
            this.target = null;
        }
        if (this.scanCooldown <= 0) {
            List entities = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(100.0, 50.0, 100.0));
            this.secondaries.clear();
            this.target = null;
            for (Entity entity : entities) {
                if (!entity.func_70089_S() || !this.func_70686_a(entity.getClass())) continue;
                if (entity instanceof EntityPlayer) {
                    if (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).func_70644_a(MobEffects.field_76441_p)) continue;
                    if (this.target == null) {
                        this.target = entity;
                    } else if (this.func_70068_e(entity) < this.func_70068_e(this.target)) {
                        this.target = entity;
                    }
                }
                if (!(entity instanceof EntityLivingBase) || !(this.func_70068_e(entity) < 10000.0) || !this.func_70685_l(entity) || entity == this.target) continue;
                this.secondaries.add(entity);
            }
            if (this.target == null && !this.secondaries.isEmpty()) {
                this.target = this.secondaries.get(this.field_70146_Z.nextInt(this.secondaries.size()));
            }
            this.scanCooldown = 50;
        }
        if (this.target != null && this.courseChangeCooldown <= 0) {
            Vec3 vec = Vec3.createVectorHelper(this.field_70165_t - this.target.field_70165_t, 0.0, this.field_70161_v - this.target.field_70161_v);
            if (this.field_70146_Z.nextInt(3) > 0) {
                vec.rotateAroundY((float)Math.PI * 2 * this.field_70146_Z.nextFloat());
            }
            double length = vec.lengthVector();
            double overshoot = 35.0;
            int wX = (int)Math.floor(this.target.field_70165_t - vec.xCoord / length * overshoot);
            int wZ = (int)Math.floor(this.target.field_70161_v - vec.zCoord / length * overshoot);
            this.setWaypoint(wX, Math.max(this.field_70170_p.func_189649_b(wX, wZ) + 20 + this.field_70146_Z.nextInt(15), (int)this.target.field_70163_u + 15), wZ);
            this.courseChangeCooldown = 40 + this.field_70146_Z.nextInt(20);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dist;
            if (this.beamTimer <= 0 && this.getBeam()) {
                this.setBeam(false);
            }
            if (this.target != null && (dist = Math.abs(this.target.field_70165_t - this.field_70165_t) + Math.abs(this.target.field_70161_v - this.field_70161_v)) < 25.0) {
                this.beamTimer = 30;
            }
            if (this.beamTimer > 0) {
                --this.beamTimer;
                if (!this.getBeam()) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.ufoBeam, SoundCategory.HOSTILE, 10.0f, 1.0f);
                    this.setBeam(true);
                }
                int ix = (int)Math.floor(this.field_70165_t);
                int iz = (int)Math.floor(this.field_70161_v);
                int iy = 0;
                for (int i = (int)Math.ceil(this.field_70163_u); i >= 0; --i) {
                    if (this.field_70170_p.func_180495_p(new BlockPos(ix, i, iz)).func_177230_c() == Blocks.field_150350_a) continue;
                    iy = i;
                    break;
                }
                if ((double)iy < this.field_70163_u) {
                    List entities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t, (double)iy, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(5.0, 0.0, 5.0));
                    for (Entity e : entities) {
                        if (!this.func_70686_a(e.getClass())) continue;
                        e.func_70097_a(ModDamageSource.causeCombineDamage((Entity)this, e), 1000.0f);
                        e.func_70015_d(5);
                        if (!(e instanceof EntityLivingBase)) continue;
                        ContaminationUtil.contaminate((EntityLivingBase)e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 5.0f);
                    }
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "ufo");
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, this.field_70165_t, (double)iy + 0.5, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, (double)iy + 0.5, this.field_70161_v, 150.0));
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, this.field_70165_t + this.field_70159_w * 0.5, (double)iy + 0.5, this.field_70161_v + this.field_70179_y * 0.5), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t + this.field_70159_w * 0.5, (double)iy + 0.5, this.field_70161_v + this.field_70179_y * 0.5, 150.0));
                }
            }
            if (this.field_70173_aa % 300 < 200) {
                if (this.field_70173_aa % 4 == 0) {
                    if (!this.secondaries.isEmpty()) {
                        Entity e = this.secondaries.get(this.field_70146_Z.nextInt(this.secondaries.size()));
                        if (!e.func_70089_S()) {
                            this.secondaries.remove(e);
                        } else {
                            this.laserAttack(e);
                        }
                    } else if (this.target != null) {
                        this.laserAttack(this.target);
                    }
                } else if (this.field_70173_aa % 4 == 2 && this.target != null) {
                    this.laserAttack(this.target);
                }
            } else if (this.field_70173_aa % 20 == 0) {
                if (!this.secondaries.isEmpty()) {
                    Entity e = this.secondaries.get(this.field_70146_Z.nextInt(this.secondaries.size()));
                    if (!e.func_70089_S()) {
                        this.secondaries.remove(e);
                    } else {
                        this.rocketAttack(e);
                    }
                } else if (this.target != null) {
                    this.rocketAttack(this.target);
                }
            } else if (this.field_70173_aa % 20 == 10 && this.target != null) {
                this.rocketAttack(this.target);
            }
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (this.courseChangeCooldown > 0) {
            double speed;
            double deltaX = (double)this.getX() - this.field_70165_t;
            double deltaY = (double)this.getY() - this.field_70163_u;
            double deltaZ = (double)this.getZ() - this.field_70161_v;
            Vec3 delta = Vec3.createVectorHelper(deltaX, deltaY, deltaZ);
            double len = delta.lengthVector();
            double d = speed = this.target instanceof EntityPlayer ? 5.0 : 2.0;
            if (len > 5.0) {
                if (this.isCourseTraversable(this.getX(), this.getY(), this.getZ(), len)) {
                    this.field_70159_w = delta.xCoord * speed / len;
                    this.field_70181_x = delta.yCoord * speed / len;
                    this.field_70179_y = delta.zCoord * speed / len;
                } else {
                    this.courseChangeCooldown = 0;
                }
            }
        }
    }

    protected void func_70609_aI() {
        if (this.getBeam()) {
            this.setBeam(false);
        }
        this.field_70181_x -= 0.05;
        if (this.field_70725_aQ == -10) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.chopperDamage, SoundCategory.HOSTILE, 10.0f, 1.0f);
        }
        if (this.field_70725_aQ == 19 && !this.field_70170_p.field_72995_K) {
            EntityNukeTorex.statFac(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0f);
            this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFacNoRad(this.field_70170_p, 25, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5));
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(200.0, 200.0, 200.0));
            for (EntityPlayer player : players) {
                AdvancementManager.grantAchievement(player, AdvancementManager.bossUFO);
                player.field_71071_by.func_70441_a(new ItemStack(ModItems.coin_ufo));
            }
        }
        super.func_70609_aI();
    }

    private void laserAttack(Entity e) {
        Vec3 vec = Vec3.createVectorHelper(this.field_70165_t - e.field_70165_t, 0.0, this.field_70161_v - e.field_70161_v);
        vec.rotateAroundY((float)Math.toRadians(-80 + this.field_70146_Z.nextInt(160)));
        vec = vec.normalize();
        double pivotX = this.field_70165_t - vec.xCoord * 10.0;
        double pivotY = this.field_70163_u + 0.5;
        double pivotZ = this.field_70161_v - vec.zCoord * 10.0;
        Vec3 heading = Vec3.createVectorHelper(e.field_70165_t - pivotX, e.field_70163_u + (double)(e.field_70131_O / 2.0f) - pivotY, e.field_70161_v - pivotZ);
        heading = heading.normalize();
        EntityBulletBase bullet = new EntityBulletBase(this.field_70170_p, BulletConfigSyncingUtil.WORM_LASER);
        bullet.shooter = this;
        bullet.func_70107_b(pivotX, pivotY, pivotZ);
        bullet.func_70186_c(heading.xCoord, heading.yCoord, heading.zCoord, 2.0f, 0.02f);
        this.field_70170_p.func_72838_d((Entity)bullet);
        this.func_184185_a(HBMSoundHandler.ballsLaser, 5.0f, 1.0f);
    }

    private void rocketAttack(Entity e) {
        Vec3 heading = Vec3.createVectorHelper(e.field_70165_t - this.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f) - this.field_70163_u - 0.5, e.field_70161_v - this.field_70161_v);
        heading = heading.normalize();
        EntityBulletBase bullet = new EntityBulletBase(this.field_70170_p, BulletConfigSyncingUtil.UFO_ROCKET);
        bullet.shooter = this;
        bullet.func_70107_b(this.field_70165_t, this.field_70163_u - 0.5, this.field_70161_v);
        bullet.func_70186_c(heading.xCoord, heading.yCoord, heading.zCoord, 2.0f, 0.02f);
        bullet.getEntityData().func_74768_a("homingTarget", e.func_145782_y());
        this.field_70170_p.func_72838_d((Entity)bullet);
        this.func_184185_a(HBMSoundHandler.richard_fire, 5.0f, 1.0f);
    }

    public boolean func_70686_a(Class clazz) {
        return clazz != this.getClass() && clazz != EntityBulletBase.class;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEAM, (Object)false);
        this.field_70180_af.func_187214_a(WAYPOINT, (Object)new BlockPos(0, 0, 0));
    }

    private boolean isCourseTraversable(double p_70790_1_, double p_70790_3_, double p_70790_5_, double p_70790_7_) {
        double d4 = ((double)this.getX() - this.field_70165_t) / p_70790_7_;
        double d5 = ((double)this.getY() - this.field_70163_u) / p_70790_7_;
        double d6 = ((double)this.getZ() - this.field_70161_v) / p_70790_7_;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = 1;
        while ((double)i < p_70790_7_) {
            this.func_174826_a(axisalignedbb.func_72317_d(d4, d5, d6));
            if (!this.field_70170_p.func_184144_a((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
    }

    public void setBeam(boolean b) {
        this.field_70180_af.func_187227_b(BEAM, (Object)b);
    }

    public boolean getBeam() {
        return (Boolean)this.field_70180_af.func_187225_a(BEAM);
    }

    public void setWaypoint(int x, int y, int z) {
        this.field_70180_af.func_187227_b(WAYPOINT, (Object)new BlockPos(x, y, z));
    }

    public BlockPos getWaypoint() {
        return (BlockPos)this.field_70180_af.func_187225_a(WAYPOINT);
    }

    public int getX() {
        return ((BlockPos)this.field_70180_af.func_187225_a(WAYPOINT)).func_177958_n();
    }

    public int getY() {
        return ((BlockPos)this.field_70180_af.func_187225_a(WAYPOINT)).func_177956_o();
    }

    public int getZ() {
        return ((BlockPos)this.field_70180_af.func_187225_a(WAYPOINT)).func_177952_p();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 500000.0;
    }
}

