/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import api.hbm.energy.IEnergyUser;
import cofh.redstoneflux.api.IEnergyProvider;
import com.hbm.config.CompatibilityConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.ParticleBurstPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityEMP
extends Entity
implements IChunkLoader {
    List<BlockPos> machines;
    int life = 12000;
    private ForgeChunkManager.Ticket loaderTicket;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityEMP(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
                this.func_70106_y();
                return;
            }
            if (this.machines == null) {
                this.allocate();
            } else {
                this.shock();
            }
            if (this.field_70173_aa > this.life) {
                this.func_70106_y();
            }
        }
    }

    private void allocate() {
        this.machines = new ArrayList<BlockPos>();
        int radius = 100;
        for (int x = -radius; x <= radius; ++x) {
            int x2 = (int)Math.pow(x, 2.0);
            for (int y = -radius; y <= radius; ++y) {
                int y2 = (int)Math.pow(y, 2.0);
                for (int z = -radius; z <= radius; ++z) {
                    int z2 = (int)Math.pow(z, 2.0);
                    if (!(Math.sqrt(x2 + y2 + z2) <= (double)radius)) continue;
                    this.add(new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z));
                }
            }
        }
    }

    private void shock() {
        for (BlockPos pos : this.machines) {
            this.emp(pos);
        }
    }

    private void add(BlockPos pos) {
        TileEntity te = this.field_70170_p.func_175625_s(pos);
        if (te == null) {
            return;
        }
        if (te instanceof IEnergyUser) {
            this.machines.add(pos);
        } else {
            try {
                if (te instanceof IEnergyProvider) {
                    this.machines.add(pos);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
            this.machines.add(pos);
        }
    }

    private void emp(BlockPos pos) {
        TileEntity te = this.field_70170_p.func_175625_s(pos);
        if (te == null) {
            return;
        }
        boolean flag = false;
        if (te instanceof IEnergyUser) {
            ((IEnergyUser)te).setPower(0L);
            flag = true;
        }
        try {
            if (te instanceof IEnergyProvider) {
                ((IEnergyProvider)te).extractEnergy(EnumFacing.UP, ((IEnergyProvider)te).getEnergyStored(EnumFacing.UP), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.DOWN, ((IEnergyProvider)te).getEnergyStored(EnumFacing.DOWN), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.NORTH, ((IEnergyProvider)te).getEnergyStored(EnumFacing.NORTH), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.SOUTH, ((IEnergyProvider)te).getEnergyStored(EnumFacing.SOUTH), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.EAST, ((IEnergyProvider)te).getEnergyStored(EnumFacing.EAST), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.WEST, ((IEnergyProvider)te).getEnergyStored(EnumFacing.WEST), false);
                flag = true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage handle = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            handle.extractEnergy(handle.getEnergyStored(), false);
            flag = true;
        }
        if (flag && this.field_70146_Z.nextInt(20) == 0) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new ParticleBurstPacket(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Block.func_149682_b((Block)Blocks.field_150399_cn), 3));
        }
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }
}

