/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.WasteLog;
import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.config.VersatileConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.main.MainRegistry;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.saveddata.AuxSavedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityFalloutRain
extends Entity
implements IConstantRenderer,
IChunkLoader {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityFalloutRain.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean done = false;
    public boolean doFallout = false;
    public boolean doFlood = false;
    public boolean doDrop = false;
    public int waterLevel = 0;
    public boolean spawnFire = false;
    private ForgeChunkManager.Ticket loaderTicket;
    private double s0;
    private double s1;
    private double s2;
    private double s3;
    private double s4;
    private double s5;
    private double s6;
    private int fallingRadius;
    private boolean firstTick = true;
    private final List<Long> chunksToProcess = new ArrayList<Long>();
    private final List<Long> outerChunksToProcess = new ArrayList<Long>();
    private int falloutTickNumber = 0;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityFalloutRain(World world) {
        super(world);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = false;
        this.field_70178_ae = true;
        this.waterLevel = EntityFalloutRain.getInt(CompatibilityConfig.fillCraterWithWater.get(world.field_73011_w.getDimension()));
        if (this.waterLevel == 0) {
            this.waterLevel = world.func_181545_F();
        } else if (this.waterLevel < 0 && this.waterLevel > -world.func_181545_F()) {
            this.waterLevel = world.func_181545_F() - this.waterLevel;
        }
        this.spawnFire = BombConfig.spawnFire;
    }

    public EntityFalloutRain(World p_i1582_1_, int maxage) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70178_ae = true;
    }

    private static int getInt(Object e) {
        if (e == null) {
            return 0;
        }
        return (Integer)e;
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    private void gatherChunks() {
        LinkedHashSet<Long> chunks = new LinkedHashSet<Long>();
        LinkedHashSet<Long> outerChunks = new LinkedHashSet<Long>();
        int outerRange = this.doFallout ? this.getScale() : this.fallingRadius;
        int adjustedMaxAngle = 20 * outerRange / 32;
        for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
            Vec3 vector = Vec3.createVectorHelper(outerRange, 0.0, 0.0);
            vector.rotateAroundY((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
            outerChunks.add(ChunkPos.func_77272_a((int)((int)(this.field_70165_t + vector.xCoord) >> 4), (int)((int)(this.field_70161_v + vector.zCoord) >> 4)));
        }
        for (int distance = 0; distance <= outerRange; distance += 8) {
            for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
                Vec3 vector = Vec3.createVectorHelper(distance, 0.0, 0.0);
                vector.rotateAroundY((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
                long chunkCoord = ChunkPos.func_77272_a((int)((int)(this.field_70165_t + vector.xCoord) >> 4), (int)((int)(this.field_70161_v + vector.zCoord) >> 4));
                if (outerChunks.contains(chunkCoord)) continue;
                chunks.add(chunkCoord);
            }
        }
        this.chunksToProcess.addAll(chunks);
        this.outerChunksToProcess.addAll(outerChunks);
        Collections.reverse(this.chunksToProcess);
        Collections.reverse(this.outerChunksToProcess);
    }

    private void unloadAllChunks() {
        if (this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    public void stompAround() {
        if (!this.chunksToProcess.isEmpty()) {
            long chunkPos = this.chunksToProcess.remove(this.chunksToProcess.size() - 1);
            int chunkPosX = (int)(chunkPos & Integer.MAX_VALUE);
            int chunkPosZ = (int)(chunkPos >> 32 & Integer.MAX_VALUE);
            for (int x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                for (int z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                    this.stomp(new BlockPos.MutableBlockPos(x, 0, z), Math.hypot((double)x - this.field_70165_t, (double)z - this.field_70161_v));
                }
            }
        } else if (!this.outerChunksToProcess.isEmpty()) {
            long chunkPos = this.outerChunksToProcess.remove(this.outerChunksToProcess.size() - 1);
            int chunkPosX = (int)(chunkPos & Integer.MAX_VALUE);
            int chunkPosZ = (int)(chunkPos >> 32 & Integer.MAX_VALUE);
            for (int x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                for (int z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                    double distance = Math.hypot((double)x - this.field_70165_t, (double)z - this.field_70161_v);
                    if (!(distance <= (double)this.getScale())) continue;
                    this.stomp(new BlockPos.MutableBlockPos(x, 0, z), distance);
                }
            }
        } else {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
                this.func_70106_y();
            } else if (this.firstTick) {
                if (this.chunksToProcess.isEmpty() && this.outerChunksToProcess.isEmpty()) {
                    this.gatherChunks();
                }
                this.firstTick = false;
            }
            if (this.falloutTickNumber >= BombConfig.fChunkSpeed) {
                if (!this.field_70128_L) {
                    long start = System.currentTimeMillis();
                    while (!this.field_70128_L && System.currentTimeMillis() < start + (long)BombConfig.falloutMS) {
                        this.stompAround();
                    }
                }
                this.falloutTickNumber = 0;
            }
            ++this.falloutTickNumber;
            if (this.field_70128_L) {
                this.unloadAllChunks();
                this.done = true;
                if (RadiationConfig.rain > 0) {
                    if (this.doFallout && this.getScale() > 100 || this.doFlood && this.getScale() > 50) {
                        this.field_70170_p.func_72912_H().func_76084_b(true);
                        this.field_70170_p.func_72912_H().func_76080_g(RadiationConfig.rain);
                    }
                    if (this.doFallout && this.getScale() > 150 || this.doFlood && this.getScale() > 100) {
                        this.field_70170_p.func_72912_H().func_76069_a(true);
                        this.field_70170_p.func_72912_H().func_76090_f(RadiationConfig.rain);
                        AuxSavedData.setThunder(this.field_70170_p, RadiationConfig.rain);
                    }
                }
            }
        }
    }

    private void letFall(World world, BlockPos.MutableBlockPos pos, int lastGapHeight, int contactHeight) {
        int chance;
        int fallChance = RadiationConfig.blocksFallCh;
        if (fallChance < 1) {
            return;
        }
        if (fallChance < 100 && (chance = world.field_73012_v.nextInt(100)) < fallChance) {
            return;
        }
        int bottomHeight = lastGapHeight;
        BlockPos.MutableBlockPos gapPos = new BlockPos.MutableBlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        for (int i = lastGapHeight; i <= contactHeight; ++i) {
            pos.func_185336_p(i);
            Block b = world.func_180495_p((BlockPos)pos).func_177230_c();
            if (b.func_176200_f((IBlockAccess)world, (BlockPos)pos)) continue;
            float hardness = b.func_149638_a(null);
            if (hardness >= 0.0f && hardness < 50.0f && i != bottomHeight) {
                gapPos.func_185336_p(bottomHeight);
                world.func_175656_a((BlockPos)gapPos, world.func_180495_p((BlockPos)pos));
                world.func_175698_g((BlockPos)pos);
            }
            ++bottomHeight;
        }
    }

    private int[] doFallout(BlockPos.MutableBlockPos pos, double dist) {
        int stoneDepth = 0;
        int maxStoneDepth = 0;
        if (dist > this.s1) {
            maxStoneDepth = 0;
        } else if (dist > this.s2) {
            maxStoneDepth = 1;
        } else if (dist > this.s3) {
            maxStoneDepth = 2;
        } else if (dist > this.s4) {
            maxStoneDepth = 3;
        } else if (dist > this.s5) {
            maxStoneDepth = 4;
        } else if (dist > this.s6) {
            maxStoneDepth = 5;
        } else if (dist <= this.s6) {
            maxStoneDepth = 6;
        }
        boolean lastReachedStone = false;
        boolean reachedStone = false;
        int contactHeight = 420;
        int lastGapHeight = 420;
        boolean gapFound = false;
        for (int y = 255; y >= 0; --y) {
            pos.func_185336_p(y);
            IBlockState b = this.field_70170_p.func_180495_p((BlockPos)pos);
            Block bblock = b.func_177230_c();
            Material bmaterial = b.func_185904_a();
            lastReachedStone = reachedStone;
            if (bblock != Blocks.field_150350_a && contactHeight == 420) {
                contactHeight = Math.min(y + 1, 255);
            }
            if (reachedStone && bmaterial != Material.field_151579_a) {
                ++stoneDepth;
            } else {
                boolean bl = reachedStone = b.func_185904_a() == Material.field_151576_e;
            }
            if (reachedStone && stoneDepth > maxStoneDepth) break;
            if (bmaterial == Material.field_151579_a || bmaterial.func_76224_d()) {
                if (y >= contactHeight) continue;
                gapFound = true;
                lastGapHeight = y;
                continue;
            }
            if (bblock == Blocks.field_150357_h || bblock == ModBlocks.ore_bedrock_oil || bblock == ModBlocks.ore_bedrock_block) {
                if (!this.field_70170_p.func_175623_d(pos.func_177984_a())) break;
                this.field_70170_p.func_175656_a(pos.func_177984_a(), ModBlocks.toxic_block.func_176223_P());
                break;
            }
            if (y == contactHeight - 1 && bblock != ModBlocks.fallout && Math.abs(this.field_70146_Z.nextGaussian() * (dist * dist) / (this.s0 * this.s0)) < 0.05 && this.field_70146_Z.nextDouble() < 0.05 && ModBlocks.fallout.func_176196_c(this.field_70170_p, pos.func_177984_a())) {
                this.placeBlockFromDist(dist, ModBlocks.fallout, pos.func_177984_a());
            }
            if (this.spawnFire && dist < this.s2 && bblock.isFlammable((IBlockAccess)this.field_70170_p, (BlockPos)pos, EnumFacing.UP) && this.field_70170_p.func_175623_d(pos.func_177984_a())) {
                this.field_70170_p.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
            }
            if (bblock == ModBlocks.waste_leaves) {
                if (dist > this.s1 || dist > (double)this.fallingRadius && (double)this.field_70170_p.field_73012_v.nextFloat() < -5.0 * ((double)this.fallingRadius / dist) + 5.0) continue;
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (bblock instanceof BlockLeaves) {
                if (dist > this.s1 || dist > (double)this.fallingRadius && (double)this.field_70170_p.field_73012_v.nextFloat() < -5.0 * ((double)this.fallingRadius / dist) + 5.0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_leaves.func_176223_P());
                    continue;
                }
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (bblock == Blocks.field_150338_P || bblock == Blocks.field_150337_Q) {
                if (!(dist < this.s0)) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush.func_176223_P());
                continue;
            }
            if (bblock instanceof BlockOre && reachedStone && !lastReachedStone && dist < this.s1) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.toxic_block.func_176223_P());
                continue;
            }
            if (bblock instanceof BlockStone || bblock == Blocks.field_150347_e) {
                double ranDist = dist * (1.0 + this.field_70170_p.field_73012_v.nextDouble() * 0.1);
                if (ranDist > this.s1 || stoneDepth == maxStoneDepth) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_slaked.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                    continue;
                }
                if (ranDist > this.s2 || stoneDepth == maxStoneDepth - 1) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_0.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                    continue;
                }
                if (ranDist > this.s3 || stoneDepth == maxStoneDepth - 2) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_1.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                    continue;
                }
                if (ranDist > this.s4 || stoneDepth == maxStoneDepth - 3) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_2.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                    continue;
                }
                if (ranDist > this.s5 || stoneDepth == maxStoneDepth - 4) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_3.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                    continue;
                }
                if (ranDist > this.s6 || stoneDepth == maxStoneDepth - 5) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_4.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                    continue;
                }
                if (!(ranDist <= this.s6) && stoneDepth != maxStoneDepth - 6) break;
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_core.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                continue;
            }
            if (bblock instanceof BlockGrass) {
                this.placeBlockFromDist(dist, ModBlocks.waste_earth, (BlockPos)pos);
                continue;
            }
            if (bblock instanceof BlockGravel) {
                this.placeBlockFromDist(dist, ModBlocks.waste_gravel, (BlockPos)pos);
                continue;
            }
            if (bblock instanceof BlockDirt) {
                BlockDirt.DirtType meta = (BlockDirt.DirtType)b.func_177229_b((IProperty)BlockDirt.field_176386_a);
                if (meta == BlockDirt.DirtType.DIRT) {
                    this.placeBlockFromDist(dist, ModBlocks.waste_dirt, (BlockPos)pos);
                    continue;
                }
                if (meta == BlockDirt.DirtType.COARSE_DIRT) {
                    this.placeBlockFromDist(dist, ModBlocks.waste_gravel, (BlockPos)pos);
                    continue;
                }
                if (meta != BlockDirt.DirtType.PODZOL) continue;
                this.placeBlockFromDist(dist, ModBlocks.waste_mycelium, (BlockPos)pos);
                continue;
            }
            if (bblock == Blocks.field_150458_ak) {
                this.placeBlockFromDist(dist, ModBlocks.waste_dirt, (BlockPos)pos);
                continue;
            }
            if (bblock instanceof BlockSnow) {
                this.placeBlockFromDist(dist, ModBlocks.waste_snow, (BlockPos)pos);
                continue;
            }
            if (bblock instanceof BlockSnowBlock) {
                this.placeBlockFromDist(dist, ModBlocks.waste_snow_block, (BlockPos)pos);
                continue;
            }
            if (bblock instanceof BlockIce) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_ice.func_176223_P());
                continue;
            }
            if (bblock instanceof BlockBush) {
                if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak) {
                    this.placeBlockFromDist(dist, ModBlocks.waste_dirt, pos.func_177977_b());
                    this.placeBlockFromDist(dist, ModBlocks.waste_grass_tall, (BlockPos)pos);
                    continue;
                }
                if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGrass) {
                    this.placeBlockFromDist(dist, ModBlocks.waste_earth, pos.func_177977_b());
                    this.placeBlockFromDist(dist, ModBlocks.waste_grass_tall, (BlockPos)pos);
                    continue;
                }
                if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150391_bh) continue;
                this.placeBlockFromDist(dist, ModBlocks.waste_mycelium, pos.func_177977_b());
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush.func_176223_P());
                continue;
            }
            if (bblock == Blocks.field_150391_bh) {
                this.placeBlockFromDist(dist, ModBlocks.waste_mycelium, (BlockPos)pos);
                continue;
            }
            if (bblock == Blocks.field_150322_A) {
                this.placeBlockFromDist(dist, ModBlocks.waste_sandstone, (BlockPos)pos);
                continue;
            }
            if (bblock == Blocks.field_180395_cM) {
                this.placeBlockFromDist(dist, ModBlocks.waste_sandstone_red, (BlockPos)pos);
                continue;
            }
            if (bblock == Blocks.field_150405_ch || bblock == Blocks.field_150406_ce) {
                this.placeBlockFromDist(dist, ModBlocks.waste_terracotta, (BlockPos)pos);
                continue;
            }
            if (bblock instanceof BlockSand) {
                BlockSand.EnumType meta = (BlockSand.EnumType)b.func_177229_b((IProperty)BlockSand.field_176504_a);
                if (this.field_70146_Z.nextInt(60) == 0) {
                    this.placeBlockFromDist(dist, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_trinitite : ModBlocks.waste_trinitite_red, (BlockPos)pos);
                    continue;
                }
                this.placeBlockFromDist(dist, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_sand : ModBlocks.waste_sand_red, (BlockPos)pos);
                continue;
            }
            if (bblock == Blocks.field_150435_aG) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150405_ch.func_176223_P());
                continue;
            }
            if (bblock == Blocks.field_150341_Y) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150365_q.func_176223_P());
                continue;
            }
            if (bblock == Blocks.field_150365_q) {
                if (!(dist < this.s5)) continue;
                int ra = this.field_70146_Z.nextInt(150);
                if (ra < 7) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150482_ag.func_176223_P());
                    continue;
                }
                if (ra >= 10) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150412_bA.func_176223_P());
                continue;
            }
            if (bblock == Blocks.field_150420_aW || bblock == Blocks.field_150419_aX) {
                if (!(dist < this.s0)) continue;
                BlockHugeMushroom.EnumType meta = (BlockHugeMushroom.EnumType)b.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a);
                if (meta == BlockHugeMushroom.EnumType.STEM) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush_block_stem.func_176223_P());
                    continue;
                }
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush_block.func_176223_P());
                continue;
            }
            if (bblock instanceof BlockLog) {
                if (!(dist < this.s0)) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, ((WasteLog)ModBlocks.waste_log).getSameRotationState(b));
                continue;
            }
            if (bmaterial == Material.field_151575_d && bblock != ModBlocks.waste_log && bblock != ModBlocks.waste_planks) {
                if (!(dist < this.s0)) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_planks.func_176223_P());
                continue;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_4) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_core.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                continue;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_3) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_4.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                continue;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_2) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_3.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                continue;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_1) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_2.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                continue;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_0) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_1.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                continue;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_slaked) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_0.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                continue;
            }
            if (b.func_177230_c() == Blocks.field_150395_bd) {
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (bblock == ModBlocks.ore_uranium) {
                if (!(dist <= this.s6)) break;
                if (this.field_70146_Z.nextInt(VersatileConfig.getSchrabOreChance()) == 0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_schrabidium.func_176223_P());
                    break;
                }
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_uranium_scorched.func_176223_P());
                break;
            }
            if (bblock == ModBlocks.ore_nether_uranium) {
                if (!(dist <= this.s5)) break;
                if (this.field_70146_Z.nextInt(VersatileConfig.getSchrabOreChance()) == 0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_nether_schrabidium.func_176223_P());
                    break;
                }
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_nether_uranium_scorched.func_176223_P());
                break;
            }
            if (bblock == ModBlocks.ore_gneiss_uranium) {
                if (!(dist <= this.s4)) break;
                if (this.field_70146_Z.nextInt(VersatileConfig.getSchrabOreChance()) == 0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_gneiss_schrabidium.func_176223_P());
                    break;
                }
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_gneiss_uranium_scorched.func_176223_P());
                break;
            }
            if (bblock == ModBlocks.brick_concrete) {
                if (this.field_70146_Z.nextInt(80) != 0) break;
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.brick_concrete_broken.func_176223_P());
                break;
            }
            if (bblock.func_149638_a(null) > 300.0f) break;
        }
        return new int[]{gapFound ? 1 : 0, lastGapHeight, contactHeight};
    }

    private int[] doNoFallout(BlockPos.MutableBlockPos pos, double dist) {
        int stoneDepth = 0;
        int maxStoneDepth = 6;
        boolean lastReachedStone = false;
        boolean reachedStone = false;
        int contactHeight = 420;
        int lastGapHeight = 420;
        boolean gapFound = false;
        for (int y = 255; y >= 0; --y) {
            pos.func_185336_p(y);
            IBlockState b = this.field_70170_p.func_180495_p((BlockPos)pos);
            Block bblock = b.func_177230_c();
            Material bmaterial = b.func_185904_a();
            lastReachedStone = reachedStone;
            if (bblock.func_149703_v() && contactHeight == 420) {
                contactHeight = Math.min(y + 1, 255);
            }
            if (reachedStone && bmaterial != Material.field_151579_a) {
                ++stoneDepth;
            } else {
                boolean bl = reachedStone = b.func_185904_a() == Material.field_151576_e;
            }
            if (reachedStone && stoneDepth > maxStoneDepth) break;
            if (bmaterial != Material.field_151579_a && !bmaterial.func_76224_d() || y >= contactHeight) continue;
            gapFound = true;
            lastGapHeight = y;
        }
        return new int[]{gapFound ? 1 : 0, lastGapHeight, contactHeight};
    }

    public void placeBlockFromDist(double dist, Block b, BlockPos pos) {
        double ranDist = dist * (1.0 + this.field_70170_p.field_73012_v.nextDouble() * 0.2);
        if (ranDist > this.s1) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(0));
        } else if (ranDist > this.s2) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(1));
        } else if (ranDist > this.s3) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(2));
        } else if (ranDist > this.s4) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(3));
        } else if (ranDist > this.s5) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(4));
        } else if (ranDist > this.s6) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(5));
        } else if (ranDist <= this.s6) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(6));
        }
    }

    private void flood(BlockPos.MutableBlockPos pos) {
        if (CompatibilityConfig.doFillCraterWithWater && this.waterLevel > 1) {
            for (int y = this.waterLevel - 1; y > 1; --y) {
                pos.func_185336_p(y);
                if (!this.field_70170_p.func_175623_d((BlockPos)pos) && this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150358_i) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150355_j.func_176223_P());
            }
        }
    }

    private void drain(BlockPos.MutableBlockPos pos) {
        for (int y = 255; y > 1; --y) {
            pos.func_185336_p(y);
            if (this.field_70170_p.func_175623_d((BlockPos)pos) || this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150355_j && this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150358_i) continue;
            this.field_70170_p.func_175698_g((BlockPos)pos);
        }
    }

    private void stomp(BlockPos.MutableBlockPos pos, double dist) {
        if (dist > this.s0 && (double)this.field_70170_p.field_73012_v.nextFloat() > (double)0.05f + (5.0 * (this.s0 / dist) - 4.0)) {
            return;
        }
        int[] gapData = null;
        gapData = this.doFallout ? this.doFallout(pos, dist) : this.doNoFallout(pos, dist);
        if (dist < (double)this.fallingRadius) {
            if (this.doDrop && gapData != null && gapData[0] == 1) {
                this.letFall(this.field_70170_p, pos, gapData[1], gapData[2]);
            }
            if (this.doFlood) {
                this.flood(pos);
            } else {
                this.drain(pos);
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setScale(nbt.func_74762_e("scale"), nbt.func_74762_e("dropRadius"));
        if (nbt.func_74764_b("chunks")) {
            this.chunksToProcess.addAll(this.readChunksFromIntArray(nbt.func_74759_k("chunks")));
        }
        if (nbt.func_74764_b("outerChunks")) {
            this.outerChunksToProcess.addAll(this.readChunksFromIntArray(nbt.func_74759_k("outerChunks")));
        }
        this.doFallout = nbt.func_74767_n("doFallout");
        this.doFlood = nbt.func_74767_n("doFlood");
    }

    private Collection<Long> readChunksFromIntArray(int[] data) {
        ArrayList<Long> coords = new ArrayList<Long>();
        boolean firstPart = true;
        int x = 0;
        for (int coord : data) {
            if (firstPart) {
                x = coord;
            } else {
                coords.add(ChunkPos.func_77272_a((int)x, (int)coord));
            }
            firstPart = !firstPart;
        }
        return coords;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("scale", this.getScale());
        nbt.func_74768_a("dropRadius", this.fallingRadius);
        nbt.func_74757_a("doFallout", this.doFallout);
        nbt.func_74757_a("doFlood", this.doFlood);
        nbt.func_74783_a("chunks", this.writeChunksToIntArray(this.chunksToProcess));
        nbt.func_74783_a("outerChunks", this.writeChunksToIntArray(this.outerChunksToProcess));
    }

    private int[] writeChunksToIntArray(List<Long> coords) {
        int[] data = new int[coords.size() * 2];
        for (int i = 0; i < coords.size(); ++i) {
            data[i * 2] = (int)(coords.get(i) & Integer.MAX_VALUE);
            data[i * 2 + 1] = (int)(coords.get(i) >> 32 & Integer.MAX_VALUE);
        }
        return data;
    }

    public void setScale(int i, int craterRadius) {
        this.field_70180_af.func_187227_b(SCALE, (Object)i);
        this.s0 = 0.8 * (double)i;
        this.s1 = 0.65 * (double)i;
        this.s2 = 0.5 * (double)i;
        this.s3 = 0.4 * (double)i;
        this.s4 = 0.3 * (double)i;
        this.s5 = 0.2 * (double)i;
        this.s6 = 0.1 * (double)i;
        this.fallingRadius = craterRadius;
        this.doDrop = this.fallingRadius > 20;
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

