/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capability;

import com.hbm.handler.HbmKeybinds;
import com.hbm.main.MainRegistry;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class HbmCapability {
    public static IHBMData getData(Entity e) {
        if (e.hasCapability(HBMDataProvider.HBM_CAP, null)) {
            return (IHBMData)e.getCapability(HBMDataProvider.HBM_CAP, null);
        }
        return HBMDataProvider.DUMMY;
    }

    public static class HBMDataProvider
    implements ICapabilitySerializable<NBTBase> {
        public static final IHBMData DUMMY = new IHBMData(){

            @Override
            public boolean getKeyPressed(HbmKeybinds.EnumKeybind key) {
                return false;
            }

            @Override
            public void setKeyPressed(HbmKeybinds.EnumKeybind key, boolean pressed) {
            }

            @Override
            public boolean getEnableBackpack() {
                return false;
            }

            @Override
            public boolean getEnableHUD() {
                return false;
            }

            @Override
            public void setEnableBackpack(boolean b) {
            }

            @Override
            public void setEnableHUD(boolean b) {
            }
        };
        @CapabilityInject(value=IHBMData.class)
        public static final Capability<IHBMData> HBM_CAP = null;
        private IHBMData instance = (IHBMData)HBM_CAP.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == HBM_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == HBM_CAP ? HBM_CAP.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return HBM_CAP.getStorage().writeNBT(HBM_CAP, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            HBM_CAP.getStorage().readNBT(HBM_CAP, (Object)this.instance, null, nbt);
        }
    }

    public static class HBMDataStorage
    implements Capability.IStorage<IHBMData> {
        public NBTBase writeNBT(Capability<IHBMData> capability, IHBMData instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            for (HbmKeybinds.EnumKeybind key : HbmKeybinds.EnumKeybind.values()) {
                tag.func_74757_a(key.name(), instance.getKeyPressed(key));
            }
            tag.func_74757_a("enableBackpack", instance.getEnableBackpack());
            tag.func_74757_a("enableHUD", instance.getEnableHUD());
            return tag;
        }

        public void readNBT(Capability<IHBMData> capability, IHBMData instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)nbt;
                for (HbmKeybinds.EnumKeybind key : HbmKeybinds.EnumKeybind.values()) {
                    instance.setKeyPressed(key, tag.func_74767_n(key.name()));
                }
                instance.setEnableBackpack(tag.func_74767_n("enableBackpack"));
                instance.setEnableHUD(tag.func_74767_n("enableHUD"));
            }
        }
    }

    public static class HBMData
    implements IHBMData {
        public static final Callable<IHBMData> FACTORY = () -> new HBMData();
        private boolean[] keysPressed = new boolean[HbmKeybinds.EnumKeybind.values().length];
        public boolean enableBackpack = true;
        public boolean enableHUD = true;

        @Override
        public boolean getKeyPressed(HbmKeybinds.EnumKeybind key) {
            return this.keysPressed[key.ordinal()];
        }

        @Override
        public void setKeyPressed(HbmKeybinds.EnumKeybind key, boolean pressed) {
            if (!this.getKeyPressed(key) && pressed) {
                if (key == HbmKeybinds.EnumKeybind.TOGGLE_JETPACK) {
                    boolean bl = this.enableBackpack = !this.enableBackpack;
                    if (this.enableBackpack) {
                        MainRegistry.proxy.displayTooltip(TextFormatting.GREEN + "Jetpack ON");
                    } else {
                        MainRegistry.proxy.displayTooltip(TextFormatting.RED + "Jetpack OFF");
                    }
                }
                if (key == HbmKeybinds.EnumKeybind.TOGGLE_HEAD) {
                    boolean bl = this.enableHUD = !this.enableHUD;
                    if (this.enableHUD) {
                        MainRegistry.proxy.displayTooltip(TextFormatting.GREEN + "HUD ON");
                    } else {
                        MainRegistry.proxy.displayTooltip(TextFormatting.RED + "HUD OFF");
                    }
                }
            }
            this.keysPressed[key.ordinal()] = pressed;
        }

        @Override
        public boolean getEnableBackpack() {
            return this.enableBackpack;
        }

        @Override
        public boolean getEnableHUD() {
            return this.enableHUD;
        }

        @Override
        public void setEnableBackpack(boolean b) {
            this.enableBackpack = b;
        }

        @Override
        public void setEnableHUD(boolean b) {
            this.enableHUD = b;
        }
    }

    public static interface IHBMData {
        public boolean getKeyPressed(HbmKeybinds.EnumKeybind var1);

        public void setKeyPressed(HbmKeybinds.EnumKeybind var1, boolean var2);

        public boolean getEnableBackpack();

        public boolean getEnableHUD();

        public void setEnableBackpack(boolean var1);

        public void setEnableHUD(boolean var1);

        default public boolean isJetpackActive() {
            return this.getEnableBackpack() && this.getKeyPressed(HbmKeybinds.EnumKeybind.JETPACK);
        }
    }
}

