/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.items.machine.ItemFFFluidDuct;
import com.hbm.tileentity.conductor.TileEntityFFDuctBaseMk2;
import com.hbm.tileentity.conductor.TileEntityFFFluidDuctMk2;
import com.hbm.tileentity.conductor.TileEntityFFFluidSuccMk2;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.Fluid;

public class BlockFluidPipeMk2
extends BlockContainer
implements IToolable,
ILookOverlay {
    public static final PropertyBool EXTRACTS = PropertyBool.func_177716_a((String)"extracts");
    private static final float p = 0.0625f;
    private static final AxisAlignedBB DUCT_BB = new AxisAlignedBB(1.0, 1.0, 1.0, -1.0, -1.0, -1.0);

    public BlockFluidPipeMk2(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)EXTRACTS, (Comparable)Boolean.valueOf(false)));
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta > 0) {
            return new TileEntityFFFluidSuccMk2();
        }
        return new TileEntityFFFluidDuctMk2();
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18nUtil.resolveKey("desc.extraction", new Object[0]));
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFFDuctBaseMk2) {
            ((TileEntityFFDuctBaseMk2)te).onNeighborChange();
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityFFDuctBaseMk2) {
            ((TileEntityFFDuctBaseMk2)te).onNeighborChange();
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityFFDuctBaseMk2) {
            ((TileEntityFFDuctBaseMk2)te).onNeighborChange();
        }
        return state;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityFFDuctBaseMk2) {
            TileEntityFFDuctBaseMk2.breakBlock(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityFFDuctBaseMk2 te;
        if (world.func_175625_s(pos) instanceof TileEntityFFDuctBaseMk2 && (te = (TileEntityFFDuctBaseMk2)world.func_175625_s(pos)) != null) {
            boolean nZ;
            boolean pZ;
            boolean nY;
            boolean pY;
            boolean nX;
            boolean pX = te.connections[3] != null;
            int mask = 0 + (pX ? 32 : 0) + ((nX = te.connections[5] != null) ? 16 : 0) + ((pY = te.connections[0] != null) ? 8 : 0) + ((nY = te.connections[1] != null) ? 4 : 0) + ((pZ = te.connections[4] != null) ? 2 : 0) + ((nZ = te.connections[2] != null) ? 1 : 0);
            if (mask == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if (mask == 32 || mask == 16 || mask == 48) {
                return new AxisAlignedBB(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
            }
            if (mask == 8 || mask == 4 || mask == 12) {
                return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
            }
            if (mask == 2 || mask == 1 || mask == 3) {
                return new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0);
            }
            return new AxisAlignedBB(nX ? 0.0 : 0.3125, nY ? 0.0 : 0.3125, nZ ? 0.0 : 0.3125, pX ? 1.0 : 0.6875, pY ? 1.0 : 0.6875, pZ ? 1.0 : 0.6875);
        }
        return DUCT_BB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.CENTER;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXTRACTS});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EXTRACTS) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return meta > 0 ? this.func_176223_P().func_177226_a((IProperty)EXTRACTS, (Comparable)Boolean.valueOf(true)) : this.func_176223_P().func_177226_a((IProperty)EXTRACTS, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        if (tool == IToolable.ToolType.SCREWDRIVER) {
            Fluid type = null;
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = world.func_180495_p(pos);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityFFDuctBaseMk2) {
                type = ((TileEntityFFDuctBaseMk2)te).getType();
            }
            boolean extracts = (Boolean)state.func_177229_b((IProperty)EXTRACTS);
            world.func_175656_a(pos, ModBlocks.fluid_duct_mk2.func_176223_P().func_177226_a((IProperty)EXTRACTS, (Comparable)Boolean.valueOf(!extracts)));
            te = world.func_175625_s(pos);
            if (te instanceof TileEntityFFDuctBaseMk2) {
                ((TileEntityFFDuctBaseMk2)te).setType(type);
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        Fluid ductFluid = null;
        if (te instanceof TileEntityFFDuctBaseMk2) {
            ductFluid = ((TileEntityFFDuctBaseMk2)te).getType();
        }
        if (ductFluid != null) {
            return ItemFFFluidDuct.getStackFromFluid(ductFluid, 1);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityFFDuctBaseMk2)) {
            return;
        }
        Fluid ductFluid = ((TileEntityFFDuctBaseMk2)te).getType();
        ArrayList<String> text = new ArrayList<String>();
        if (ductFluid == null) {
            text.add("\u00a77" + I18nUtil.resolveKey("desc.none", new Object[0]));
        } else {
            int color = ModForgeFluids.getFluidColor(ductFluid);
            text.add("&[" + color + "&]" + I18nUtil.resolveKey(ductFluid.getUnlocalizedName(), new Object[0]));
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

