/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IConveyorBelt;
import api.hbm.block.IEnterableBlock;
import com.hbm.blocks.network.BlockConveyorChute;
import com.hbm.entity.item.EntityMovingItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlockConveyorLift
extends BlockConveyorChute {
    public BlockConveyorLift(Material materialIn, String s) {
        super(materialIn, s);
    }

    @Override
    public EnumFacing getTravelDirection(World world, BlockPos pos, Vec3d itemPos) {
        boolean top;
        boolean bottom = !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof IConveyorBelt);
        boolean bl = top = !(world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof IConveyorBelt) && !bottom && !(world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof IEnterableBlock);
        if (!top) {
            return EnumFacing.DOWN;
        }
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
    }

    @Override
    public Vec3d getTravelLocation(World world, int x, int y, int z, Vec3d itemPos, double speed) {
        BlockPos pos = new BlockPos(x, y, z);
        EnumFacing dir = this.getTravelDirection(world, pos, itemPos);
        Vec3d snap = this.getClosestSnappingPosition(world, pos, itemPos);
        Vec3d dest = new Vec3d(snap.field_72450_a - (double)dir.func_82601_c() * speed, snap.field_72448_b - (double)dir.func_96559_d() * speed, snap.field_72449_c - (double)dir.func_82599_e() * speed);
        Vec3d motion = new Vec3d(dest.field_72450_a - itemPos.field_72450_a, dest.field_72448_b - itemPos.field_72448_b, dest.field_72449_c - itemPos.field_72449_c);
        double len = motion.func_72433_c();
        Vec3d ret = new Vec3d(itemPos.field_72450_a + motion.field_72450_a / len * speed, itemPos.field_72448_b + motion.field_72448_b / len * speed, itemPos.field_72449_c + motion.field_72449_c / len * speed);
        return ret;
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityItem && entity.field_70173_aa > 10 && !entity.field_70128_L) {
            EntityMovingItem item = new EntityMovingItem(world);
            item.setItemStack(((EntityItem)entity).func_92059_d());
            Vec3d entityPos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Vec3d snap = this.getClosestSnappingPosition(world, pos, entityPos);
            item.func_70080_a(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c, 0.0f, 0.0f);
            world.func_72838_d((Entity)item);
            entity.func_70106_y();
        }
    }

    @Override
    public Vec3d getClosestSnappingPosition(World world, BlockPos pos, Vec3d itemPos) {
        boolean top;
        boolean bottom = !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof IConveyorBelt);
        boolean bl = top = !(world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof IConveyorBelt) && !bottom && !(world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof IEnterableBlock);
        if (!top) {
            return new Vec3d((double)pos.func_177958_n() + 0.5, itemPos.field_72448_b, (double)pos.func_177952_p() + 0.5);
        }
        return super.getClosestSnappingPosition(world, pos, itemPos);
    }

    @Override
    public int getUpdatedType(World world, BlockPos pos, EnumFacing side) {
        boolean hasChuteBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockConveyorChute;
        boolean hasInputBelt = false;
        Block inputBlock = world.func_180495_p(pos.func_177967_a(side.func_176734_d(), 1)).func_177230_c();
        if (inputBlock instanceof IConveyorBelt || inputBlock instanceof IEnterableBlock) {
            hasInputBelt = true;
        }
        if (hasChuteBelow) {
            return hasInputBelt ? 2 : 1;
        }
        return 0;
    }
}

