/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IConveyorBelt;
import api.hbm.block.IEnterableBlock;
import com.hbm.blocks.network.BlockConveyor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConveyorChute
extends BlockConveyor {
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)2);

    public BlockConveyorChute(Material materialIn, String s) {
        super(materialIn, s);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (belowBlock instanceof IConveyorBelt || belowBlock instanceof IEnterableBlock) {
            entity.field_70159_w *= 4.0;
            entity.field_70181_x *= 4.0;
            entity.field_70179_y *= 4.0;
        } else if (entity.field_70163_u > (double)pos.func_177956_o() + 0.25) {
            entity.field_70159_w *= 3.0;
            entity.field_70181_x *= 3.0;
            entity.field_70179_y *= 3.0;
        }
    }

    @Override
    public Vec3d getTravelLocation(World world, int x, int y, int z, Vec3d itemPos, double speed) {
        BlockPos pos = new BlockPos(x, y, z);
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (belowBlock instanceof IConveyorBelt || belowBlock instanceof IEnterableBlock) {
            speed *= 4.0;
        } else if (itemPos.field_72448_b > (double)pos.func_177956_o() + 0.25) {
            speed *= 3.0;
        }
        return super.getTravelLocation(world, x, y, z, itemPos, speed);
    }

    @Override
    public EnumFacing getTravelDirection(World world, BlockPos pos, Vec3d itemPos) {
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (belowBlock instanceof IConveyorBelt || belowBlock instanceof IEnterableBlock || itemPos.field_72448_b > (double)pos.func_177956_o() + 0.25) {
            return EnumFacing.UP;
        }
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(this.getUpdatedType(worldIn, pos, placer.func_174811_aO().func_176734_d()))));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(this.getUpdatedType(world, pos))));
    }

    public int getUpdatedType(World world, BlockPos pos) {
        return this.getUpdatedType(world, pos, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
    }

    public int getUpdatedType(World world, BlockPos pos, EnumFacing side) {
        boolean hasChuteBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockConveyorChute;
        boolean hasInputBelt = false;
        Block inputBlock = world.func_180495_p(pos.func_177967_a(side, 1)).func_177230_c();
        if (inputBlock instanceof IConveyorBelt || inputBlock instanceof IEnterableBlock) {
            hasInputBelt = true;
        }
        if (hasChuteBelow) {
            return hasInputBelt ? 2 : 1;
        }
        return 0;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() - 2 + ((Integer)state.func_177229_b((IProperty)TYPE) << 2);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.values()[meta % 4 + 2];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta >> 2));
    }
}

