/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IConveyorBelt;
import api.hbm.block.IToolable;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.item.EntityMovingItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConveyor
extends Block
implements IConveyorBelt,
IToolable {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final AxisAlignedBB CONVEYOR_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockConveyor(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add(this);
    }

    @Override
    public boolean canItemStay(World world, int x, int y, int z, Vec3d itemPos) {
        return true;
    }

    @Override
    public Vec3d getTravelLocation(World world, int x, int y, int z, Vec3d itemPos, double speed) {
        BlockPos pos = new BlockPos(x, y, z);
        EnumFacing dir = this.getTravelDirection(world, pos, itemPos);
        Vec3d snap = this.getClosestSnappingPosition(world, pos, itemPos);
        Vec3d dest = new Vec3d(snap.field_72450_a - (double)dir.func_82601_c() * speed, snap.field_72448_b - (double)dir.func_96559_d() * speed, snap.field_72449_c - (double)dir.func_82599_e() * speed);
        Vec3d motion = new Vec3d(dest.field_72450_a - itemPos.field_72450_a, dest.field_72448_b - itemPos.field_72448_b, dest.field_72449_c - itemPos.field_72449_c);
        double len = motion.func_72433_c();
        Vec3d ret = new Vec3d(itemPos.field_72450_a + motion.field_72450_a / len * speed, itemPos.field_72448_b + motion.field_72448_b / len * speed, itemPos.field_72449_c + motion.field_72449_c / len * speed);
        return ret;
    }

    public EnumFacing getTravelDirection(World world, BlockPos pos, Vec3d itemPos) {
        return EnumFacing.func_82600_a((int)world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)));
    }

    @Override
    public Vec3d getClosestSnappingPosition(World world, BlockPos pos, Vec3d itemPos) {
        EnumFacing dir = this.getTravelDirection(world, pos, itemPos);
        double posX = MathHelper.func_151237_a((double)itemPos.field_72450_a, (double)pos.func_177958_n(), (double)(pos.func_177958_n() + 1));
        double posZ = MathHelper.func_151237_a((double)itemPos.field_72449_c, (double)pos.func_177952_p(), (double)(pos.func_177952_p() + 1));
        double x = (double)pos.func_177958_n() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        double y = (double)pos.func_177956_o() + 0.25;
        if (dir.func_176740_k() == EnumFacing.Axis.X) {
            x = posX;
        } else if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            z = posZ;
        }
        return new Vec3d(x, y, z);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityItem && entity.field_70173_aa > 10 && !entity.field_70128_L) {
            EntityMovingItem item = new EntityMovingItem(world);
            item.setItemStack(((EntityItem)entity).func_92059_d());
            Vec3d entityPos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Vec3d snap = this.getClosestSnappingPosition(world, pos, entityPos);
            item.func_70080_a(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c, 0.0f, 0.0f);
            world.func_72838_d((Entity)item);
            entity.func_70106_y();
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.CENTER;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CONVEYOR_BB;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    protected int getPathDirection(int meta) {
        if (meta >= 6 && meta <= 9) {
            return 1;
        }
        if (meta >= 10 && meta <= 13) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        int meta;
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        int newMeta = meta = this.func_176201_c(state);
        int dir = this.getPathDirection(meta);
        if (!player.func_70093_af()) {
            if (meta > 9) {
                meta -= 8;
            }
            if (meta > 5) {
                meta -= 4;
            }
            EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
            newMeta = facing.func_176746_e().func_176745_a() + dir * 4;
        } else {
            newMeta = dir < 2 ? (newMeta += 4) : (newMeta -= 8);
        }
        IBlockState newState = this.func_176203_a(newMeta);
        world.func_180501_a(pos, newState, 3);
        return true;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

