/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.inventory.HeatRecipes;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntitySolarBoiler;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineSolarBoiler
extends BlockDummyable
implements ITooltipProvider,
ILookOverlay {
    public MachineSolarBoiler(Material materialIn, String s) {
        super(materialIn, s);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta >= 12) {
            return new TileEntitySolarBoiler();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, false, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    public boolean func_180639_a(World world, BlockPos pos1, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof ItemForgeFluidIdentifier) {
                int[] pos = this.findCore((IBlockAccess)world, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p());
                if (pos == null) {
                    return false;
                }
                TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
                if (!(te instanceof TileEntitySolarBoiler)) {
                    return false;
                }
                TileEntitySolarBoiler boiler = (TileEntitySolarBoiler)te;
                Fluid type = ItemForgeFluidIdentifier.getType(player.func_184586_b(hand));
                if (!HeatRecipes.hasBoilRecipe(type)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cNo recipe found for \u00a7e" + type.getLocalizedName(new FluidStack(type, 1))));
                    return false;
                }
                boiler.setTankType(0, type);
                boiler.func_70296_d();
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7eRecipe changed to \u00a7a" + type.getLocalizedName(new FluidStack(type, 1))));
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, x += dir.offsetX * o, y + 2, z += dir.offsetZ * o);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        this.addStandardInfo(tooltip);
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(te instanceof TileEntitySolarBoiler)) {
            return;
        }
        TileEntitySolarBoiler heater = (TileEntitySolarBoiler)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(String.format("%,d", heater.heat) + " TU");
        text.add("\u00a7a-> \u00a7r" + String.format("%,d", heater.heatInput) + " TU/t");
        if (heater.types[0] != null) {
            text.add("\u00a7a-> \u00a7r" + heater.types[0].getLocalizedName(new FluidStack(heater.types[0], 1)) + ": " + heater.tanks[0].getFluidAmount() + "/" + heater.tanks[0].getCapacity() + "mB");
        }
        if (heater.types[1] != null) {
            text.add("\u00a7c<- \u00a7r" + heater.types[1].getLocalizedName(new FluidStack(heater.types[1], 1)) + ": " + heater.tanks[1].getFluidAmount() + "/" + heater.tanks[1].getCapacity() + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

