/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.fluid;

import com.hbm.blocks.ModBlocks;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ContaminationUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class ToxicBlock
extends BlockFluidClassic {
    private DamageSource damageSource;

    public ToxicBlock(Fluid fluid, Material material, DamageSource source, String s) {
        super(fluid, material);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(null);
        this.setQuantaPerBlock(4);
        this.damageSource = source;
        this.displacements.put(this, false);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70110_aj();
        if (entityIn instanceof EntityLivingBase) {
            ContaminationUtil.contaminate((EntityLivingBase)entityIn, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 50.0f);
        } else if (entityIn instanceof EntityFallingBlock) {
            entityIn.func_70106_y();
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.reactToBlocks(world, pos.func_177974_f())) {
            world.func_175656_a(pos.func_177974_f(), this.getRandomSellafite(world));
        }
        if (this.reactToBlocks(world, pos.func_177976_e())) {
            world.func_175656_a(pos.func_177976_e(), this.getRandomSellafite(world));
        }
        if (this.reactToBlocks(world, pos.func_177984_a())) {
            world.func_175656_a(pos, this.getRandomSellafite(world));
        }
        if (this.reactToBlocks(world, pos.func_177977_b())) {
            world.func_175656_a(pos.func_177977_b(), this.getRandomSellafite(world));
        }
        if (this.reactToBlocks(world, pos.func_177968_d())) {
            world.func_175656_a(pos.func_177968_d(), this.getRandomSellafite(world));
        }
        if (this.reactToBlocks(world, pos.func_177978_c())) {
            world.func_175656_a(pos.func_177978_c(), this.getRandomSellafite(world));
        }
        if (world.field_73012_v.nextInt(15) == 0) {
            RadiationSavedData.incrementRad(world, pos, 300.0f, 3000.0f);
        }
        super.func_180650_b(world, pos, state, rand);
    }

    private IBlockState getRandomSellafite(World world) {
        int n = world.field_73012_v.nextInt(100);
        if (n < 2) {
            return ModBlocks.sellafield_core.func_176203_a(world.field_73012_v.nextInt(4));
        }
        if (n < 20) {
            return ModBlocks.sellafield_4.func_176203_a(world.field_73012_v.nextInt(4));
        }
        if (n < 60) {
            return ModBlocks.sellafield_3.func_176203_a(world.field_73012_v.nextInt(4));
        }
        return ModBlocks.sellafield_2.func_176203_a(world.field_73012_v.nextInt(4));
    }

    public boolean reactToBlocks(World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (world.func_180495_p(pos).func_185904_a() != ModBlocks.fluidtoxic) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_185904_a().func_76224_d()) {
                return true;
            }
            if (state.func_185904_a() == Material.field_151576_e && state.func_177230_c().func_149638_a(null) < 1000.0f && state.func_177230_c() != ModBlocks.sellafield_2 && state.func_177230_c() != ModBlocks.sellafield_3 && state.func_177230_c() != ModBlocks.sellafield_4 && state.func_177230_c() != ModBlocks.sellafield_core) {
                return true;
            }
        }
        return false;
    }

    public int func_149738_a(World world) {
        return 15;
    }
}

