/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.version.VersionUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class NBTBuilder<T extends NBTBase> {
    private final Map<String, T> map = new LinkedHashMap<String, T>();
    private int index = 0;

    public static <K, V> NBTTagList fromMap(Map<? extends K, ? extends V> map2, String keyName, String valueName, Function<? super K, ? extends NBTBase> keyFunction, Function<? super V, ? extends NBTBase> valueFunction) {
        return map2.entrySet().stream().map(MapStreamSyntax.toEntry(keyFunction.compose(Map.Entry::getKey), valueFunction.compose(Map.Entry::getValue))).map(MapStreamSyntax.toAny((k, v) -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a(keyName, (NBTBase)k);
            compound.func_74782_a(valueName, (NBTBase)v);
            return compound;
        })).collect(VersionUtil.toNBTList());
    }

    public static <K, V> Map<K, V> fromList(NBTTagList list, Function<? super NBTTagCompound, ? extends K> keyFunction, Function<? super NBTTagCompound, ? extends V> valueFunction, Predicate<? super K> keyFilter, Predicate<? super V> valuePredicate) {
        HashMap<K, V> map2 = new HashMap<K, V>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound at = list.func_150305_b(i);
            K key = keyFunction.apply((NBTTagCompound)at);
            V value = valueFunction.apply((NBTTagCompound)at);
            if (!keyFilter.test(key) || !valuePredicate.test(value)) continue;
            map2.put(key, value);
        }
        return map2;
    }

    public static JsonObject fromBlockState(IBlockState state) {
        JsonObject object = new JsonObject();
        object.addProperty("name", Objects.requireNonNull(state.func_177230_c().getRegistryName()).toString());
        JsonObject properties = new JsonObject();
        state.func_177228_b().entrySet().stream().map(MapStreamSyntax.valuesBi(NBTBuilder::getPropertyName)).map(MapStreamSyntax.keys(IProperty::func_177701_a)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((JsonObject)properties).addProperty(arg_0, arg_1)));
        object.add("properties", (JsonElement)properties);
        return object;
    }

    public static Optional<IBlockState> getStateFromJson(JsonObject object) {
        return Optional.ofNullable(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)object, (String)"name")))).filter(Predicate.isEqual(Blocks.field_150350_a).negate()).map(Block::func_176223_P).map(iBlockState -> {
            IBlockState state = iBlockState;
            JsonObject properties = JsonUtils.func_152754_s((JsonObject)object, (String)"properties");
            Map map2 = iBlockState.func_177227_a().stream().map(MapStreamSyntax.toEntry(IProperty::func_177701_a, Function.identity())).collect(MapStreamSyntax.entryToMap());
            List collect = properties.entrySet().stream().map(MapStreamSyntax.values(JsonElement::getAsString)).map(MapStreamSyntax.keys(map2::get)).filter(MapStreamSyntax.byKey(Objects::nonNull)).map(MapStreamSyntax.valuesBi(IProperty::func_185929_b)).flatMap(e -> ((com.google.common.base.Optional)e.getValue()).asSet().stream().map(MapStreamSyntax.toEntry(o -> (IProperty)e.getKey(), Function.identity()))).collect(Collectors.toList());
            for (Map.Entry e2 : collect) {
                state = NBTBuilder.setValue(state, (IProperty)e2.getKey(), e2.getValue());
            }
            return state;
        });
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> entry) {
        return property.func_177702_a(entry);
    }

    private static <T extends Comparable<T>> IBlockState setValue(IBlockState state, IProperty<T> property, Object entry) {
        return state.func_177226_a(property, (Comparable)entry);
    }

    public NBTBuilder<T> setTag(Map.Entry<String, T> entry) {
        return this.setTag(entry.getKey(), (NBTBase)entry.getValue());
    }

    public NBTBuilder<T> setTag(String key, T value) {
        this.map.put(key, value);
        return this;
    }

    public NBTBuilder<T> appendTag(T value) {
        this.map.put(String.valueOf(this.index), value);
        ++this.index;
        return this;
    }

    public static <T extends NBTBase> NBTBuilder<T> appendAll(NBTBuilder<T> b1, NBTBuilder<T> b2) {
        b1.map.putAll(b2.map);
        return b1;
    }

    public static NBTBuilder<NBTBase> empty() {
        return new NBTBuilder<NBTBase>();
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        this.map.forEach((arg_0, arg_1) -> ((NBTTagCompound)tag).func_74782_a(arg_0, arg_1));
        return tag;
    }

    public NBTTagList toList() {
        NBTTagList list = new NBTTagList();
        this.map.values().forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        return list;
    }
}

