/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockPump;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.IAttachable;
import com.yogpc.qp.tile.IAttachment;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.IModule;
import com.yogpc.qp.tile.ReplacerModule;
import com.yogpc.qp.tile.TilePump;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.tuple.Pair;
import scala.Symbol;

public class TileReplacer
extends APacketTile
implements IAttachment,
IDebugSender {
    public static final Symbol SYMBOL = Symbol.apply((String)"Replacer");
    private static final List<Predicate<IBlockState>> rejects = new ArrayList<Predicate>(Arrays.asList(state -> Item.func_150898_a((Block)state.func_177230_c()) == Items.field_190931_a, state -> state.func_177230_c().hasTileEntity(state), state -> state.func_185904_a() == Material.field_151594_q, TilePump::isLiquid, MapStreamSyntax.always_false()));
    private EnumFacing facing;
    private boolean loading = false;
    private IBlockState toReplaceState = Blocks.field_150350_a.func_176223_P();
    private final ReplacerModule module = ReplacerModule.apply(this);

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    public void onLoad() {
        super.onLoad();
        if (this.loading) {
            this.loading = false;
            this.connection();
        }
    }

    public void neighborChanged() {
        this.connection();
    }

    public void onPlaced() {
        this.connection();
    }

    private void connection() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.machineDisabled) {
            Map.Entry<EnumFacing, IAttachable> entry = Stream.of(EnumFacing.values()).map(f -> Pair.of((Object)f, (Object)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f)))).filter(MapStreamSyntax.byValue(IAttachable.class::isInstance)).map(MapStreamSyntax.values(IAttachable.class::cast)).filter(MapStreamSyntax.byEntry((facing, t) -> t.connect(facing.func_176734_d(), IAttachment.Attachments.REPLACER))).findFirst().orElse((Map.Entry<EnumFacing, IAttachable>)Pair.of(null, (Object)IAttachable.dummy));
            if (entry.getKey() == null || entry.getValue().connectAttachment(entry.getKey().func_176734_d(), IAttachment.Attachments.REPLACER, false)) {
                this.setConnectTo(entry.getKey());
            }
            Predicate accept = rejects.stream().reduce(MapStreamSyntax.always_false(), Predicate::or).negate();
            this.toReplaceState = Optional.of(this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a())).filter(accept).orElse(QuarryPlusI.dummyBlock().func_176223_P());
        }
    }

    @Override
    public void setConnectTo(@Nullable EnumFacing facing) {
        IBlockState state;
        this.facing = facing;
        if (this.func_145830_o() && facing != null ^ (Boolean)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)BlockPump.CONNECTED)) {
            InvUtils.setNewState(this.field_145850_b, this.field_174879_c, this, state.func_177226_a((IProperty)BlockPump.CONNECTED, (Comparable)Boolean.valueOf(facing != null)));
        }
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = Optional.of(compound.func_74779_i("facing")).filter(MapStreamSyntax.not(String::isEmpty)).map(EnumFacing::func_176739_a).orElse(null);
        this.loading = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74778_a("facing", Optional.ofNullable(this.facing).map(Enum::name).orElse(""));
        return super.func_189515_b(compound);
    }

    public IBlockState getReplaceState() {
        return this.toReplaceState;
    }

    @Override
    public String getDebugName() {
        return "tile.quarryreplacer.name";
    }

    @Override
    public List<? extends ITextComponent> getDebugMessages() {
        return Stream.of("Connect: " + this.facing, "toReplaceState: " + this.toReplaceState, "Module: " + this.module).map(TextComponentString::new).collect(Collectors.toList());
    }
}

