/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockBookMover;
import com.yogpc.qp.gui.TranslationKeys;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.version.VersionUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public interface IEnchantableTile {
    public static final int FortuneID = Enchantment.func_185258_b((Enchantment)Enchantments.field_185308_t);
    public static final int SilktouchID = Enchantment.func_185258_b((Enchantment)Enchantments.field_185306_r);
    public static final int EfficiencyID = Enchantment.func_185258_b((Enchantment)Enchantments.field_185305_q);
    public static final int UnbreakingID = Enchantment.func_185258_b((Enchantment)Enchantments.field_185307_s);
    public static final BiPredicate<Integer, Integer> isValidEnch = (id, level) -> {
        if (id == FortuneID || id == UnbreakingID) {
            return level <= 3;
        }
        if (id == EfficiencyID) {
            return level <= 5;
        }
        return id == SilktouchID && level == 1;
    };

    public void G_ReInit();

    @Nonnull
    public Map<Integer, Integer> getEnchantments();

    public void setEnchantment(short var1, short var2);

    default public void sendEnchantMassage(EntityPlayer player) {
        Util.getEnchantmentsChat(this).forEach(c -> VersionUtil.sendMessage(player, c));
    }

    default public ItemStack getEnchantedPickaxe() {
        ItemStack stack = new ItemStack((Item)QuarryPlusI.itemQuarryPickaxe());
        this.getEnchantments().entrySet().stream().filter(MapStreamSyntax.byEntry(Config.content().disableMapJ().get(BlockBookMover.SYMBOL).booleanValue() ? isValidEnch : (k, v) -> true)).map(MapStreamSyntax.keys(Enchantment::func_185262_c)).filter(MapStreamSyntax.byKey(APacketTile.nonNull)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((ItemStack)stack).func_77966_a(arg_0, arg_1)));
        return stack;
    }

    public static class Util {
        public static void init(@Nonnull IEnchantableTile te, @Nullable NBTTagList tagList) {
            VersionUtil.nbtListStream(tagList).forEach(nbt -> te.setEnchantment(nbt.func_74765_d("id"), nbt.func_74765_d("lvl")));
            te.G_ReInit();
        }

        static List<ITextComponent> getEnchantmentsChat(@Nonnull IEnchantableTile te) {
            Map<Integer, Integer> enchantments = te.getEnchantments();
            if (enchantments.size() <= 0) {
                return Collections.singletonList(new TextComponentTranslation("chat.plusenchantno", new Object[0]));
            }
            LinkedList collect = enchantments.entrySet().stream().map(MapStreamSyntax.keys(Enchantment::func_185262_c)).filter(MapStreamSyntax.byKey(APacketTile.nonNull)).map(MapStreamSyntax.toAny((enchantment, level) -> new TextComponentTranslation("chat.indent", new Object[]{new TextComponentTranslation(enchantment.func_77320_a(), new Object[0]), enchantment.func_77325_b() != 1 ? new TextComponentTranslation(TranslationKeys.ENCHANT_LEVELS.getOrDefault(level, level.toString()), new Object[0]) : ""}))).collect(Collectors.toCollection(LinkedList::new));
            collect.addFirst(new TextComponentTranslation("chat.plusenchant", new Object[0]));
            return collect;
        }

        public static void enchantmentToIS(@Nonnull IEnchantableTile te, @Nonnull ItemStack is) {
            te.getEnchantments().entrySet().stream().map(MapStreamSyntax.keys(Enchantment::func_185262_c)).filter(MapStreamSyntax.byKey(APacketTile.nonNull)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((ItemStack)is).func_77966_a(arg_0, arg_1)));
        }

        @Nonnull
        public static <T extends IEnchantableTile> Consumer<T> initConsumer(ItemStack stack) {
            return t -> Util.init(t, stack.func_77986_q());
        }
    }
}

