/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.Config;
import com.yogpc.qp.block.BlockExpPump;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.IModule;
import com.yogpc.qp.tile.TileExpPump;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.tile.TileReplacer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import scala.Symbol;

public interface IAttachment {
    public void setConnectTo(@Nullable EnumFacing var1);

    public IModule getModule();

    public static class Attachments<T extends APacketTile>
    implements Predicate<TileEntity>,
    Function<TileEntity, Optional<T>> {
        public static final Attachments<TilePump> FLUID_PUMP = new Attachments("FLUID_PUMP", () -> Config.content().disableMapJ().get(Symbol.apply((String)"PumpPlus")), (APacketTile[])new TilePump[0]);
        public static final Attachments<TileExpPump> EXP_PUMP = new Attachments("EXP_PUMP", () -> Config.content().disableMapJ().get(BlockExpPump.SYMBOL), (APacketTile[])new TileExpPump[0]);
        public static final Attachments<TileReplacer> REPLACER = new Attachments("REPLACER", () -> Config.content().disableMapJ().get(TileReplacer.SYMBOL), (APacketTile[])new TileReplacer[0]);
        public static final Set<Attachments<? extends APacketTile>> ALL = Collections.unmodifiableSet(Arrays.stream(Attachments.class.getDeclaredFields()).filter(field -> field.getType() == Attachments.class).map(field -> {
            try {
                return (Attachments)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet()));
        @Nonnull
        private final String name;
        @Nonnull
        private final BooleanSupplier isDisabled;
        @Nonnull
        private final Class<T> clazz;

        private Attachments(@Nonnull String name, @Nonnull BooleanSupplier isDisabled, T ... ts) {
            this.name = name;
            this.isDisabled = isDisabled;
            this.clazz = ts.getClass().getComponentType();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Optional<T> apply(TileEntity tileEntity) {
            if (this.test(tileEntity)) {
                return Optional.of(this.clazz.cast(tileEntity));
            }
            return Optional.empty();
        }

        @Override
        public boolean test(TileEntity tileEntity) {
            return this.clazz.isInstance(tileEntity) && !this.isDisabled.getAsBoolean();
        }

        public Optional<IModule> module(TileEntity tileEntity) {
            return Optional.ofNullable(tileEntity).flatMap(MapStreamSyntax.optCast(IAttachment.class)).map(IAttachment::getModule);
        }

        static {
            assert (!ALL.isEmpty());
        }
    }
}

