/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.google.common.base.Stopwatch;
import com.yogpc.qp.Config$;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.EnergyUsage;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001-\u00111\"\u00128fe\u001eLH)\u001a2vO*\u00111\u0001B\u0001\u0005i&dWM\u0003\u0002\u0006\r\u0005\u0011\u0011\u000f\u001d\u0006\u0003\u000f!\tQ!_8ha\u000eT\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\n\u0011\u0005Q)R\"\u0001\u0002\n\u0005Y\u0011!AC!Q_^,'\u000fV5mK\")\u0001\u0004\u0001C\u00013\u00051A(\u001b8jiz\"\"AG\u000e\u0011\u0005Q\u0001\u0001\"B\u0002\u0018\u0001\u0004\u0019\u0002BB\u000f\u0001A\u0003%a$\u0001\u0005uS2,g*Y7f!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003mC:<'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012aa\u0015;sS:<\u0007BB\u0014\u0001A\u0003%\u0001&A\u0002h_R\u00042!D\u0015,\u0013\tQcBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000eY%\u0011QF\u0004\u0002\u0005\u0019>tw\r\u0003\u00040\u0001\u0001\u0006I\u0001K\u0001\u0005kN,G\r\u0003\u00042\u0001\u0001\u0006KAM\u0001\tO>$8i\\;oiB\u0011QbM\u0005\u0003i9\u00111!\u00138u\u0011\u00191\u0004\u0001)Q\u0005e\u0005IQo]3e\u0007>,h\u000e\u001e\u0005\u0007q\u0001\u0001\u000b\u0015B\u0016\u0002\u0013Q|G/\u00197Vg\u0016$\u0007B\u0002\u001e\u0001A\u0003&1&A\u0005v\u0019\u0006\u001cH\u000fV5dW\"1A\b\u0001Q!\n-\n\u0011b\u001a'bgR$\u0016nY6\t\ry\u0002\u0001\u0015)\u0003,\u0003)a\u0017m\u001d;PkR\u0004X\u000f\u001e\u0005\u0007\u0001\u0002\u0001\u000bQB\u0016\u0002\u00055T\u0007B\u0002\"\u0001A\u0003%1)A\u0005ti>\u0004x+\u0019;dQB\u0011AiS\u0007\u0002\u000b*\u0011aiR\u0001\u0005E\u0006\u001cXM\u0003\u0002I\u0013\u000611m\\7n_:T!A\u0013\u0005\u0002\r\u001d|wn\u001a7f\u0013\taUIA\u0005Ti>\u0004x/\u0019;dQ\"1a\n\u0001Q!\n-\n\u0011b\u001d;beR$\u0016.\\3\t\rA\u0003\u0001\u0015!\u0003R\u0003!)8/Y4f\u001b\u0006\u0004\b\u0003\u0002*X3.j\u0011a\u0015\u0006\u0003)V\u000bq!\\;uC\ndWM\u0003\u0002W\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001b&aA'baB\u0011ACW\u0005\u00037\n\u00111\"\u00128fe\u001eLXk]1hK\")Q\f\u0001C\u0001=\u000691\u000f^1si\u0016$W#A0\u0011\u00055\u0001\u0017BA1\u000f\u0005\u001d\u0011un\u001c7fC:DQa\u0019\u0001\u0005\u0002\u0011\fQa\u001d;beR$\u0012!\u001a\t\u0003\u001b\u0019L!a\u001a\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006S\u0002!IA[\u0001\bO\u0016$H+[7f+\u0005Y\u0003\"\u00027\u0001\t\u0013q\u0016AC8viB,H/\u00138g_\")a\u000e\u0001C\u0001_\u0006\u0019Qo]3\u0015\t\u0015\u0004(\u000f\u001e\u0005\u0006c6\u0004\raK\u0001\u0007C6|WO\u001c;\t\u000bMl\u0007\u0019A0\u0002\u0011MLW.\u001e7bi\u0016DQ!^7A\u0002e\u000bQ!^:bO\u0016DQa\u001e\u0001\u0005\u0002a\f1aZ3u)\t)\u0017\u0010C\u0003rm\u0002\u00071\u0006C\u0003|\u0001\u0011\u0005A-\u0001\u0003uS\u000e\\\u0007\"B?\u0001\t\u0013!\u0017!\u00039sS:$\u0018J\u001c4p\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005Qq-\u001a;B]\u0012$\u0016nY6\u0015\u0007\u0015\f\u0019\u0001C\u0003r}\u0002\u00071\u0006\u0003\u0004\u0002\b\u0001!\t\u0001Z\u0001\u0007M&t\u0017n\u001d5\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001d\ri\u00111C\u0005\u0004\u0003+q\u0011A\u0002)sK\u0012,g-C\u0002&\u00033Q1!!\u0006\u000f\u0001")
public class EnergyDebug {
    private final APowerTile tile;
    private final String tileName;
    private final long[] got;
    private final long[] used;
    private int gotCount;
    private int usedCount;
    private long totalUsed;
    private long uLastTick;
    private long gLastTick;
    private long lastOutput;
    public final long com$yogpc$qp$tile$EnergyDebug$$mj;
    private final Stopwatch stopWatch;
    private long startTime;
    private final Map<EnergyUsage, Object> usageMap;

    public boolean started() {
        return this.stopWatch.isRunning();
    }

    public void start() {
        if (this.started()) {
            return;
        }
        this.stopWatch.start();
        this.startTime = this.getTime();
    }

    private long getTime() {
        return this.tile.func_145831_w().func_82737_E();
    }

    private boolean outputInfo() {
        return Config$.MODULE$.content().debug() && this.tile.isOutputEnergyInfo();
    }

    public void use(long amount, boolean simulate, EnergyUsage usage) {
        if (this.outputInfo() && !simulate) {
            if (!this.started()) {
                this.start();
            }
            long tick2 = this.getTime();
            int energy = Math.round(amount);
            if (tick2 == this.uLastTick) {
                int n = this.usedCount - 1;
                this.used[n] = this.used[n] + (long)energy;
            } else {
                ++this.usedCount;
                if (this.usedCount > 100) {
                    return;
                }
                this.used[this.usedCount - 1] = energy;
                this.uLastTick = tick2;
            }
            this.totalUsed += (long)energy;
            this.usageMap.update((Object)usage, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.usageMap.getOrElse((Object)usage, (Function0)new Serializable(this){

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            })) + (long)energy)));
            return;
        }
    }

    public void get(long amount) {
        if (this.outputInfo()) {
            long tick2 = this.getTime();
            int energy = Math.round(amount);
            if (tick2 == this.gLastTick) {
                if (this.gotCount > 0) {
                    int n = this.gotCount - 1;
                    this.got[n] = this.got[n] + (long)energy;
                }
            } else {
                ++this.gotCount;
                if (this.gotCount > 100) {
                    Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)this.gotCount));
                    return;
                }
                this.got[this.gotCount - 1] = energy;
                this.gLastTick = tick2;
            }
            return;
        }
    }

    public void tick() {
        if (this.getTime() - this.lastOutput >= 100L) {
            if (this.lastOutput == 0L) {
                this.usedCount = 0;
                this.gotCount = 0;
                this.lastOutput = this.getTime();
            } else if (this.outputInfo()) {
                this.printInfo();
            }
        }
    }

    private void printInfo() {
        long allUsed = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(this.used).take(this.usedCount)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / this.com$yogpc$qp$tile$EnergyDebug$$mj;
        long allGot = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(this.got).take(this.gotCount)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / this.com$yogpc$qp$tile$EnergyDebug$$mj;
        if (allUsed != 0L || allGot != 0L) {
            if (allUsed == 0L || this.usedCount == 0) {
                if (this.gotCount == 0) {
                    QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used 0 MJ, got 0 MJ"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName})));
                } else {
                    QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used 0 MJ, got ", " in 100 ticks (", " RF/t)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, BoxesRunTime.boxToLong((long)allGot), BoxesRunTime.boxToLong((long)(allGot * 10L / (long)this.gotCount))})));
                }
            } else if (this.gotCount == 0) {
                QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used ", " MJ in ", " ticks (", " RF/t), got 0 MJ"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, BoxesRunTime.boxToLong((long)allUsed), BoxesRunTime.boxToInteger((int)this.usedCount), BoxesRunTime.boxToLong((long)(allUsed * 10L / (long)this.usedCount))})));
            } else {
                QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used ", " MJ in ", " ticks (", " RF/t), got ", " in ", " ticks (", " RF/t)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, BoxesRunTime.boxToLong((long)allUsed), BoxesRunTime.boxToInteger((int)this.usedCount), BoxesRunTime.boxToLong((long)(allUsed * 10L / (long)this.usedCount)), BoxesRunTime.boxToLong((long)allGot), BoxesRunTime.boxToInteger((int)this.gotCount), BoxesRunTime.boxToLong((long)(allGot * 10L / (long)this.gotCount))})));
            }
        }
        this.usedCount = 0;
        this.gotCount = 0;
        this.lastOutput = this.getTime();
    }

    public void getAndTick(long amount) {
        this.get(amount);
        this.tick();
    }

    public void finish() {
        if (this.started()) {
            this.stopWatch.stop();
            if (this.outputInfo()) {
                this.printInfo();
                long time = this.getTime() - this.startTime > 0L ? this.getTime() - this.startTime : 1L;
                QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " finished its work and took ", ", ", " ticks. Used ", " MJ at ", " RF/t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, this.stopWatch.toString(), BoxesRunTime.boxToLong((long)time), BoxesRunTime.boxToLong((long)(this.totalUsed / this.com$yogpc$qp$tile$EnergyDebug$$mj)), BoxesRunTime.boxToLong((long)(this.totalUsed * 10L / time / this.com$yogpc$qp$tile$EnergyDebug$$mj))})));
                this.usageMap.foreach((Function1)new Serializable(this){
                    private final /* synthetic */ EnergyDebug $outer;

                    public final void apply(Tuple2<EnergyUsage, Object> x0$1) {
                        Tuple2<EnergyUsage, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            EnergyUsage usage = (EnergyUsage)((Object)tuple2._1());
                            long amount = tuple2._2$mcJ$sp();
                            QuarryPlus.LOGGER.info(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)((Object)usage)), " used ")).append((Object)BoxesRunTime.boxToLong((long)(amount / this.$outer.com$yogpc$qp$tile$EnergyDebug$$mj))).append((Object)"MJ.").toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.usageMap.clear();
                this.totalUsed = 0L;
                this.startTime = 0L;
                this.uLastTick = 0L;
                this.gLastTick = 0L;
                this.lastOutput = 0L;
            }
            this.stopWatch.reset();
            return;
        }
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Debugger for ", ". ", " t: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, this.stopWatch, BoxesRunTime.boxToLong((long)this.totalUsed)}));
    }

    public EnergyDebug(APowerTile tile) {
        this.tile = tile;
        this.tileName = ((Object)((Object)tile)).getClass().getSimpleName();
        this.got = (long[])Array$.MODULE$.ofDim(100, ClassTag$.MODULE$.Long());
        this.used = (long[])Array$.MODULE$.ofDim(100, ClassTag$.MODULE$.Long());
        this.gotCount = 0;
        this.usedCount = 0;
        this.totalUsed = 0L;
        this.uLastTick = 0L;
        this.gLastTick = 0L;
        this.lastOutput = 0L;
        this.com$yogpc$qp$tile$EnergyDebug$$mj = APowerTile.MJToMicroMJ;
        this.stopWatch = Stopwatch.createUnstarted();
        this.startTime = 0L;
        this.usageMap = Map$.MODULE$.empty();
    }
}

