/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.advquarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileAdvQuarry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import scala.collection.convert.WrapAsJava$;

public class AdvContentMessage
implements IMessage {
    private BlockPos pos;
    private int dim;
    private Map<FluidStack, FluidTank> map;

    public static AdvContentMessage create(TileAdvQuarry quarry) {
        AdvContentMessage message = new AdvContentMessage();
        message.pos = quarry.func_174877_v();
        message.dim = quarry.func_145831_w().field_73011_w.getDimension();
        message.map = WrapAsJava$.MODULE$.mutableMapAsJavaMap(quarry.fluidStacks());
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) throws IOException {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.map = new HashMap<FluidStack, FluidTank>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
            FluidTank tank = new FluidTank(null, 0);
            Optional.ofNullable(buffer.func_150793_b()).ifPresent(arg_0 -> ((FluidTank)tank).readFromNBT(arg_0));
            if (tank.getFluidAmount() == 0) continue;
            this.map.put(stack, tank);
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.writeInt(this.map.size());
        this.map.forEach((fluidStack, fluidTank) -> {
            buffer.func_150786_a(fluidStack.writeToNBT(new NBTTagCompound()));
            buffer.func_150786_a(fluidTank.writeToNBT(new NBTTagCompound()));
        });
    }

    @Override
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> Optional.ofNullable((TileAdvQuarry)world.func_175625_s(this.pos)).ifPresent(quarry -> {
                quarry.fluidStacks().clear();
                this.map.forEach((fluidStack, fluidTank) -> quarry.fluidStacks().put(fluidStack, fluidTank));
            }));
        }
        return null;
    }
}

