/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.advquarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileAdvQuarry;
import com.yogpc.qp.tile.TileAdvQuarry$DigRange$;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.util.TriConsumer;

public class AdvActionMessage
implements IMessage {
    private BlockPos pos;
    private int dim;
    private Actions action;
    private NBTTagCompound tag;

    public static AdvActionMessage create(TileAdvQuarry quarry, Actions action2) {
        return AdvActionMessage.create(quarry, action2, new NBTTagCompound());
    }

    public static AdvActionMessage create(TileAdvQuarry quarry, Actions action2, NBTTagCompound compound) {
        AdvActionMessage message = new AdvActionMessage();
        message.pos = quarry.func_174877_v();
        message.dim = quarry.func_145831_w().field_73011_w.getDimension();
        message.action = action2;
        message.tag = compound;
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) throws IOException {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.action = (Actions)buffer.func_179257_a(Actions.class);
        this.tag = buffer.func_150793_b();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.func_179249_a((Enum)this.action);
        buffer.func_150786_a(this.tag);
    }

    @Override
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        TileEntity entity;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim && (entity = world.func_175625_s(this.pos)) instanceof TileAdvQuarry) {
            TileAdvQuarry quarry = (TileAdvQuarry)entity;
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(this.action.runnable(quarry, this.tag, QuarryPlus.proxy.getPacketPlayer(ctx.netHandler)));
        }
        return null;
    }

    public static enum Actions {
        QUICK_START(TileAdvQuarry::noFrameStart),
        CHANGE_RANGE((quarry, rangeNBT) -> quarry.digRange_$eq(TileAdvQuarry$DigRange$.MODULE$.readFromNBT((NBTTagCompound)rangeNBT))),
        MODULE_INV((TriConsumer<TileAdvQuarry, NBTTagCompound, EntityPlayer>)((TriConsumer)(q, t, p) -> q.openModuleInv((EntityPlayer)p)));

        private final TriConsumer<TileAdvQuarry, NBTTagCompound, EntityPlayer> consumer;

        private Actions(Consumer<TileAdvQuarry> consumer) {
            this.consumer = (quarry, nbtTagCompound, p) -> consumer.accept((TileAdvQuarry)quarry);
        }

        private Actions(BiConsumer<TileAdvQuarry, NBTTagCompound> consumer) {
            this.consumer = (q, t, p) -> consumer.accept((TileAdvQuarry)q, (NBTTagCompound)t);
        }

        private Actions(TriConsumer<TileAdvQuarry, NBTTagCompound, EntityPlayer> consumer) {
            this.consumer = consumer;
        }

        Runnable runnable(TileAdvQuarry quarry, NBTTagCompound compound, EntityPlayer player) {
            return () -> this.consumer.accept((Object)quarry, (Object)compound, (Object)player);
        }
    }
}

