/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.modules;

import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.modules.IDisabled;
import com.yogpc.qp.modules.IModuleItem;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.ExpPumpModule;
import com.yogpc.qp.tile.IModule;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import scala.Symbol;

public class ItemExpPumpModule
extends Item
implements IDisabled,
IModuleItem {
    public static final String Key_xp = "xp";

    public ItemExpPumpModule() {
        this.setRegistryName("quarryplus", "exppump_module");
        this.func_77655_b("exppump_module");
        this.func_77637_a(QuarryPlusI.creativeTab());
    }

    @Override
    public Symbol getSymbol() {
        return Symbol.apply((String)"ModuleExpPump");
    }

    @Override
    public <T extends APowerTile> Function<T, IModule> getModule(ItemStack stack) {
        int xp = this.getXp(stack).orElse(0);
        return t -> {
            ExpPumpModule module = ExpPumpModule.fromTile(t, value -> stack.func_77983_a(Key_xp, (NBTBase)new NBTTagInt(value)));
            module.xp_$eq(xp);
            return module;
        };
    }

    private Optional<Integer> getXp(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p()).map(tag -> tag.func_74762_e(Key_xp)).filter(i -> i > 0);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.getXp(stack).ifPresent(integer -> tooltip.add("xp: " + integer));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack;
        int xp;
        if (!playerIn.func_70093_af() && (xp = this.getXp(stack = playerIn.func_184586_b(handIn)).orElse(0).intValue()) > 0) {
            Optional.ofNullable(stack.func_77978_p()).ifPresent(t -> t.func_82580_o(Key_xp));
            stack.func_77982_d((NBTTagCompound)Optional.ofNullable(stack.func_77978_p()).filter(t -> !t.func_82582_d()).orElse(null));
            if (!worldIn.field_72995_K) {
                EntityXPOrb orb = new EntityXPOrb(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, xp);
                worldIn.func_72838_d((Entity)orb);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

