/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.crafttweaker;

import com.yogpc.qp.integration.crafttweaker.CT;
import com.yogpc.qp.recipe.WorkbenchRecipe;
import com.yogpc.qp.tile.ItemDamage;
import com.yogpc.qp.utils.IngredientWithCount;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.quarryplus.WorkbenchPlus")
public class WorkBenchCTRegister {
    public static final String packageName = "mods.quarryplus.WorkbenchPlus";
    private static final AtomicInteger COUNTER = new AtomicInteger(1);

    private WorkBenchCTRegister() {
    }

    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output, float energy) {
        WorkBenchCTRegister.addRecipe(new IIngredient[]{input}, output, energy);
    }

    @ZenMethod
    public static void addRecipe(IIngredient[] inputs2, IItemStack output, float energy) {
        List inputsList = Stream.of(inputs2).filter(Objects::nonNull).map(i -> new IngredientWithCount(new CTIngredient((IIngredient)i), i.getAmount())).map(Collections::singletonList).collect(Collectors.toList());
        Optional.ofNullable(output).flatMap(i -> i.getItems().stream().flatMap(WorkBenchCTRegister::stackList).findFirst()).ifPresent(out -> CT.actions.add(new Add((ItemStack)out, inputsList, energy)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        ItemDamage itemDamage = ItemDamage.apply(CraftTweakerMC.getItemStack((IItemStack)output));
        CT.actions.add(new RemoveByOut(itemDamage));
    }

    @ZenMethod
    public static void removeRecipe(String recipeId) {
        ResourceLocation name = new ResourceLocation(recipeId);
        CT.actions.add(new RemoveById(name));
    }

    private static Stream<ItemStack> stackList(@Nullable IItemStack stack) {
        if (stack == null) {
            return Stream.empty();
        }
        return stack.getItems().stream().map(CraftTweakerMC::getItemStack).filter(Objects::nonNull).filter(MapStreamSyntax.not(ItemStack::func_190926_b));
    }

    private static class CTIngredient
    extends Ingredient {
        @Nonnull
        private final IIngredient ingredient;

        public CTIngredient(@Nonnull IIngredient ingredient) {
            super(CraftTweakerMC.getItemStacks((IItemStack[])ingredient.getItemArray()));
            this.ingredient = ingredient;
        }

        public boolean apply(@Nullable ItemStack stack) {
            if (stack == null || stack.func_190926_b()) {
                return false;
            }
            return this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }

        public boolean isSimple() {
            return false;
        }
    }

    private static class RemoveById
    implements IAction {
        private final ResourceLocation name;

        public RemoveById(@Nonnull ResourceLocation name) {
            this.name = name;
        }

        public void apply() {
            WorkbenchRecipe.removeRecipe(this.name);
        }

        public String describe() {
            return "QuarryPlus CTRemoveById id:" + this.name;
        }
    }

    private static class RemoveByOut
    implements IAction {
        private final ItemDamage output;

        public RemoveByOut(@Nonnull ItemDamage output) {
            this.output = output;
        }

        public void apply() {
            WorkbenchRecipe.removeRecipe(this.output);
        }

        public String describe() {
            return "QuarryPlus CTRemoveByOut o:" + this.output;
        }
    }

    private static class Add
    implements IAction {
        private final ItemStack out;
        private final List<List<IngredientWithCount>> inputs;
        private final double energy;

        private Add(@Nonnull ItemStack out, @Nonnull List<List<IngredientWithCount>> inputs2, double energy) {
            this.out = out;
            this.inputs = inputs2;
            this.energy = energy;
        }

        public void apply() {
            ResourceLocation name = new ResourceLocation("crafttweaker", "quarryplus_workbench_" + COUNTER.getAndIncrement());
            WorkbenchRecipe.addIngredientRecipe(name, this.out, this.energy, this.inputs, true);
        }

        public String describe() {
            return "QuarryPlus CTAdd i:" + this.inputs + " o:" + this.out;
        }
    }
}

