/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.container;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.container.SlotUnlimited;
import com.yogpc.qp.container.SlotWorkbench;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.packet.workbench.RecipeSyncMessage;
import com.yogpc.qp.tile.TileWorkbench;
import com.yogpc.qp.version.VersionUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerWorkbench
extends Container {
    private final TileWorkbench tile;
    private final EntityPlayer player;
    private static final int sourceSlot = 27;
    private static final int recipeSlot = 18;
    private static final int playerSlot = 36;

    public ContainerWorkbench(EntityPlayer player, TileWorkbench tw) {
        int col;
        int row;
        this.tile = tw;
        this.player = player;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotUnlimited(tw, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotWorkbench(tw, col + row * 9 + 27, 8 + col * 18, 90 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, col, 8 + col * 18, 198));
        }
        if (!this.tile.func_145831_w().field_72995_K) {
            PacketHandler.sendToClient(RecipeSyncMessage.create(this.tile.func_174877_v(), this.tile.func_145831_w().field_73011_w.getDimension(), this.tile.getSearcher()), (EntityPlayerMP)player);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        if (27 <= index && index < 45) {
            return VersionUtil.empty();
        }
        ItemStack src = VersionUtil.empty();
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack remain = slot.func_75211_c();
            src = remain.func_77946_l();
            if (index < 27) {
                if (src.func_77985_e()) {
                    if (!this.func_75135_a(remain, 45, 81, true)) {
                        return VersionUtil.empty();
                    }
                } else {
                    for (int i = 80; i >= 45 && VersionUtil.nonEmpty(remain); --i) {
                        int maxSize;
                        Slot destinationSlot = (Slot)this.field_75151_b.get(i);
                        if (!destinationSlot.func_75216_d()) {
                            int maxSize2 = Math.min(slot.func_75219_a(), remain.func_77976_d());
                            destinationSlot.func_75215_d(remain.func_77979_a(maxSize2));
                            continue;
                        }
                        ItemStack dest = destinationSlot.func_75211_c();
                        if (!ContainerWorkbench.areStackable(dest, remain)) continue;
                        int newSize = VersionUtil.getCount(dest) + VersionUtil.getCount(remain);
                        if (newSize <= (maxSize = Math.min(slot.func_75219_a(), remain.func_77976_d()))) {
                            VersionUtil.setCount(remain, 0);
                            VersionUtil.setCount(dest, newSize);
                            slot.func_75218_e();
                            continue;
                        }
                        if (VersionUtil.getCount(dest) >= maxSize) continue;
                        VersionUtil.shrink(remain, maxSize - VersionUtil.getCount(dest));
                        VersionUtil.setCount(dest, maxSize);
                        slot.func_75218_e();
                    }
                    if (VersionUtil.nonEmpty(remain)) {
                        return VersionUtil.empty();
                    }
                }
            } else if (!this.n_mergeItemStack(remain)) {
                return VersionUtil.empty();
            }
            if (VersionUtil.isEmpty(remain)) {
                slot.func_75215_d(VersionUtil.empty());
            } else {
                slot.func_75218_e();
            }
            if (VersionUtil.getCount(remain) == VersionUtil.getCount(src)) {
                return VersionUtil.empty();
            }
            VersionUtil.onTake(slot, playerIn, remain);
        }
        return src;
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        if (listener instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)listener;
            PacketHandler.sendToClient(TileMessage.create(this.tile), playerMP);
        }
        this.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.tile.func_174885_b(id, data);
    }

    public void func_75142_b() {
        for (int i = 45; i < this.field_75151_b.size(); ++i) {
            ItemStack itemStack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemStack1 = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemStack1, (ItemStack)itemStack)) continue;
            boolean clientStackChanged = !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)itemStack1, (ItemStack)itemStack);
            itemStack1 = VersionUtil.isEmpty(itemStack) ? VersionUtil.empty() : itemStack.func_77946_l();
            this.field_75153_a.set(i, (Object)itemStack1);
            if (!clientStackChanged) continue;
            for (IContainerListener listener2 : this.field_75149_d) {
                listener2.func_71111_a((Container)this, i, itemStack1);
            }
        }
        if (!this.tile.func_145831_w().field_72995_K) {
            PacketHandler.sendToClient(TileMessage.create(this.tile), (EntityPlayerMP)this.player);
        }
        this.field_75149_d.forEach(listener -> listener.func_175173_a((Container)this, (IInventory)this.tile));
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (27 <= slotId && slotId < 45 && clickTypeIn == ClickType.PICKUP) {
            int index = slotId - 27;
            if (index < this.tile.recipesList.size()) {
                if (dragType == 0) {
                    if (index == this.tile.getRecipeIndex()) {
                        this.tile.workContinue = !this.tile.workContinue;
                    } else {
                        this.tile.setCurrentRecipeIndex(index);
                    }
                } else if (dragType == 1) {
                    this.tile.setCurrentRecipeIndex(-1);
                }
            }
            return VersionUtil.empty();
        }
        if (0 <= slotId && slotId < 27 && clickTypeIn == ClickType.PICKUP) {
            InventoryPlayer inventoryplayer = player.field_71071_by;
            ItemStack itemstack = VersionUtil.empty();
            Slot slot = (Slot)this.field_75151_b.get(slotId);
            if (slot != null) {
                ItemStack slotStack = slot.func_75211_c();
                ItemStack playerStack = inventoryplayer.func_70445_o();
                if (VersionUtil.nonEmpty(slotStack)) {
                    itemstack = slotStack.func_77946_l();
                }
                if (VersionUtil.isEmpty(slotStack)) {
                    if (VersionUtil.nonEmpty(playerStack) && slot.func_75214_a(playerStack)) {
                        int l2;
                        int n = l2 = dragType == 0 ? VersionUtil.getCount(playerStack) : 1;
                        if (l2 > slot.func_178170_b(playerStack)) {
                            l2 = slot.func_178170_b(playerStack);
                        }
                        slot.func_75215_d(playerStack.func_77979_a(l2));
                    }
                } else if (VersionUtil.isEmpty(playerStack)) {
                    if (VersionUtil.isEmpty(slotStack)) {
                        slot.func_75215_d(VersionUtil.empty());
                        inventoryplayer.func_70437_b(VersionUtil.empty());
                    } else {
                        int k2 = dragType == 0 ? Math.min(VersionUtil.getCount(slotStack), slotStack.func_77976_d()) : Math.min((VersionUtil.getCount(slotStack) + 1) / 2, slotStack.func_77976_d());
                        inventoryplayer.func_70437_b(slot.func_75209_a(k2));
                        if (VersionUtil.isEmpty(slotStack)) {
                            slot.func_75215_d(VersionUtil.empty());
                        }
                        VersionUtil.onTake(slot, player, inventoryplayer.func_70445_o());
                    }
                } else if (ContainerWorkbench.areStackable(slotStack, playerStack)) {
                    int j2 = dragType == 0 ? VersionUtil.getCount(playerStack) : 1;
                    VersionUtil.shrink(playerStack, j2);
                    VersionUtil.grow(slotStack, j2);
                }
                slot.func_75218_e();
            }
            return itemstack;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    protected boolean n_mergeItemStack(ItemStack stack) {
        int i;
        boolean flag = false;
        for (i = 0; i < 27 && VersionUtil.nonEmpty(stack); ++i) {
            int maxSize;
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack itemstack = slot.func_75211_c();
            if (!VersionUtil.nonEmpty(itemstack) || !ContainerWorkbench.areStackable(stack, itemstack)) continue;
            int j = VersionUtil.getCount(itemstack) + VersionUtil.getCount(stack);
            if (j <= (maxSize = slot.func_75219_a())) {
                VersionUtil.setCount(stack, 0);
                VersionUtil.setCount(itemstack, j);
                slot.func_75218_e();
                flag = true;
                continue;
            }
            if (VersionUtil.getCount(itemstack) >= maxSize) continue;
            if (Config.content().debug()) {
                QuarryPlus.LOGGER.info("ContainerWorkbench#mergeItemStack itemStack.getCount() < maxSize");
            }
            VersionUtil.shrink(stack, maxSize - VersionUtil.getCount(itemstack));
            VersionUtil.setCount(itemstack, maxSize);
            slot.func_75218_e();
            flag = true;
        }
        if (VersionUtil.nonEmpty(stack)) {
            for (i = 0; i < 27; ++i) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemStack1 = slot1.func_75211_c();
                if (!VersionUtil.isEmpty(itemStack1) || !slot1.func_75214_a(stack)) continue;
                slot1.func_75215_d(stack.func_77979_a(VersionUtil.getCount(stack)));
                slot1.func_75218_e();
                flag = true;
                break;
            }
        }
        return flag;
    }

    private static boolean areStackable(ItemStack stack1, ItemStack stack2) {
        return VersionUtil.nonEmpty(stack2) && stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

