/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.tile.TileSolidQuarry;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import scala.Symbol;

public class BlockSolidQuarry
extends ADismCBlock {
    public static final Symbol SYMBOL = Symbol.apply((String)"SolidFuleQuarry");

    public BlockSolidQuarry() {
        super(Material.field_151573_f, "solidquarry", ItemBlock::new);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(t -> {
                t.G_ReInit();
                TileSolidQuarry.requestTicket.accept(t);
            });
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTING});
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_renew_powerConfigure);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_ReInit);
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.quarry.restart", new Object[0]), false);
            return true;
        }
        if (!playerIn.func_70093_af()) {
            playerIn.openGui((Object)QuarryPlus.instance(), QuarryPlusI.guiIdSolidQuarry(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)ACTING);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a() | (powered ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    @Override
    protected boolean canRotate() {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSolidQuarry();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileSolidQuarry) {
            TileSolidQuarry inventory = (TileSolidQuarry)entity;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inventory.func_70301_a(0));
            worldIn.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

