/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import cofh.api.block.IDismantleable;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.QPBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.tile.IEnchantableTile;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import scala.Function1;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.block.IDismantleable", modid="cofhcore"), @Optional.Interface(iface="ic2.api.tile.IWrenchable", modid="ic2")})
public abstract class ADismCBlock
extends QPBlock
implements IDismantleable,
IWrenchable {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool ACTING = PropertyBool.func_177716_a((String)"acting");

    protected ADismCBlock(Material material, String name, Function<QPBlock, ? extends ItemBlock> generator) {
        super(material, name, generator);
    }

    protected ADismCBlock(Material material, String name, Function1<QPBlock, ? extends ItemBlock> generator, boolean dummy) {
        super(material, name, generator, dummy);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (InvUtils.isDebugItem(playerIn, hand)) {
            return true;
        }
        if (playerIn.func_70093_af() && this.canDismantle(worldIn, pos, state, playerIn) && BuildcraftHelper.isWrench(playerIn, hand, playerIn.func_184586_b(hand), new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            if (!worldIn.field_72995_K) {
                ADismCBlock.dismantle(worldIn, pos, state, false);
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="cofhcore")
    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        return ADismCBlock.dismantle(world, pos, state, returnDrops);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        if ("wrench".equals(type)) {
            return true;
        }
        return super.isToolEffective(type, state);
    }

    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return this != QuarryPlusI.blockChunkDestroyer();
    }

    public static ArrayList<ItemStack> dismantle(World world, BlockPos pos, IBlockState state, boolean returnDrops) {
        NonNullList list = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(list, (IBlockAccess)world, pos, state, 0);
        world.func_175698_g(pos);
        if (!returnDrops) {
            for (ItemStack drop : list) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)drop);
            }
        }
        return new ArrayList<ItemStack>((Collection<ItemStack>)list);
    }

    protected void addEnchantedItem(World worldIn, IBlockState state, IEnchantableTile tile, List<ItemStack> drops) {
        int count = this.quantityDropped(state, 0, worldIn.field_73012_v);
        Item it = this.func_180660_a(state, worldIn.field_73012_v, 0);
        for (int i = 0; i < count; ++i) {
            ItemStack is = new ItemStack(it, 1, this.func_180651_a(state));
            IEnchantableTile.Util.enchantmentToIS(tile, is);
            drops.add(is);
        }
    }

    protected static EnumFacing get2dOrientation(double x1, double z1, double x2, double z2) {
        double Dz = z1 - z2;
        double Dx = x1 - x2;
        double angle = Math.atan2(Dz, Dx) / Math.PI * 180.0 + 180.0;
        if (angle < 45.0 || angle > 315.0) {
            return EnumFacing.EAST;
        }
        if (angle < 135.0) {
            return EnumFacing.SOUTH;
        }
        if (angle < 225.0) {
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    protected abstract boolean canRotate();

    protected boolean validFacing(EnumFacing facing) {
        return EnumFacing.Plane.HORIZONTAL.apply(facing);
    }

    @Optional.Method(modid="ic2")
    public EnumFacing getFacing(World world, BlockPos pos) {
        if (this.canRotate()) {
            return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        }
        return EnumFacing.UP;
    }

    @Optional.Method(modid="ic2")
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        if (this.canRotate()) {
            TileEntity entity = world.func_175625_s(pos);
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177229_b((IProperty)FACING) == newDirection || !this.validFacing(newDirection)) {
                return false;
            }
            if (entity != null) {
                InvUtils.setNewState(world, pos, entity, state.func_177226_a((IProperty)FACING, (Comparable)newDirection));
            } else {
                world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)newDirection));
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public boolean canSetFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        return this.canRotate() && world.func_180495_p(pos).func_177229_b((IProperty)FACING) != newDirection && this.validFacing(newDirection);
    }

    @Optional.Method(modid="ic2")
    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        return this != QuarryPlusI.blockChunkDestroyer();
    }

    @Optional.Method(modid="ic2")
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        Block block = state.func_177230_c();
        if (te instanceof IEnchantableTile) {
            IEnchantableTile tile = (IEnchantableTile)te;
            ItemStack stack = new ItemStack(block);
            IEnchantableTile.Util.enchantmentToIS(tile, stack);
            if (world.func_180495_p(pos) == state) {
                world.func_175698_g(pos);
            }
            return Collections.singletonList(stack);
        }
        NonNullList list = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(list, (IBlockAccess)world, pos, state, fortune);
        return list;
    }
}

