/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.items.armor.IJetpack;
import com.zuxelus.comboarmors.items.armor.ItemArmorTankUtility;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import ic2.core.IC2;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorExoJet
extends ItemArmorTankUtility
implements IJetpack {
    public ItemArmorExoJet() {
        super(EntityEquipmentSlot.CHEST, FluidRegistry.getFluid((String)"ic2biogas"), 30000);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "comboarmors:textures/armor/exo_jet.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"info.upgrade_module_installed", (Object[])new Object[0]));
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74767_n("flight")) {
            tooltip.add(I18n.func_135052_a((String)"info.flight_turbine_installed", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, world, tooltip, advanced);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack itemStack = new ItemStack(ModItems.exoJet, 1);
        this.fillTank(itemStack);
        itemStack.func_77964_b(1);
        items.add((Object)itemStack);
        itemStack = new ItemStack(ModItems.exoJet, 1);
        itemStack.func_77964_b(this.func_77612_l());
        items.add((Object)itemStack);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (player.field_71071_by.field_70460_b.get(2) != stack) {
            return;
        }
        NBTTagCompound nbtData = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbtData.func_74767_n("isFlyActive")) {
            return;
        }
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.hover_mode_enabled", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.hover_mode_disabled", new Object[0]));
                }
            }
        }
        if (IC2.keyboard.isJumpKeyDown(player) || hoverMode) {
            jetpackUsed = this.useJetpack(player, stack, hoverMode, nbtData.func_74767_n("isFlyActive"));
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        this.playAudioSource(player, jetpackUsed);
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public boolean useJetpack(EntityPlayer player, ItemStack jetpack, boolean hoverMode, boolean boost) {
        int worldHeight;
        float y;
        float retruster;
        float forwardpower;
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.2f;
        if (this.getCharge(jetpack) / (double)this.getCapacity(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * this.getCharge(jetpack) / (double)this.getCapacity(jetpack) * (double)dropPercentage);
        }
        if (IC2.keyboard.isForwardKeyDown(player) && (forwardpower = power * (retruster = hoverMode ? 0.5f : 0.15f) * 2.0f) > 0.0f) {
            if (boost) {
                player.func_191958_b(0.0f, 0.0f, 0.4f * forwardpower, 0.1f);
            } else {
                player.func_191958_b(0.0f, 0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        if ((y = (float)player.field_70163_u) > (float)((worldHeight = IC2.getWorldHeight((World)player.func_130014_f_())) - 25)) {
            if (y > (float)worldHeight) {
                y = worldHeight;
            }
            power = power * ((float)worldHeight - y) / 25.0f;
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.2f;
            }
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.2f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = hoverMode ? 1 : 2;
        this.drainFromJetpack(jetpack, consume);
        this.updateDamage(jetpack);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    private boolean drainFromJetpack(ItemStack stack, int amount) {
        if (FluidUtil.getFluidContained((ItemStack)stack) == null) {
            return false;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        assert (handler != null);
        FluidStack drained = handler.drain(amount, false);
        if (drained == null || drained.amount < amount) {
            return false;
        }
        handler.drain(amount, true);
        this.updateDamage(stack);
        return true;
    }
}

