/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.proxy;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.event.FMLEventHandler;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.proxy.IProxy;
import com.ldtteam.structurize.tileentities.TileEntityMultiBlock;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CommonProxy
implements IProxy {
    private static final Map<String, NBTTagCompound> playerPropertiesData = new HashMap<String, NBTTagCompound>();

    public static void storeEntityData(String name, NBTTagCompound compound) {
        playerPropertiesData.put(name, compound);
    }

    public static NBTTagCompound getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @SubscribeEvent
    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> event) {
        ModBlocks.init((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(@NotNull RegistryEvent.Register<Item> event) {
        ModItems.init((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)event.getRegistry());
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityMultiBlock.class, (ResourceLocation)new ResourceLocation("structurize", "multiblock"));
    }

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler());
    }

    @Override
    public void openBuildToolWindow(BlockPos pos) {
    }

    @Override
    public void openScanToolWindow(BlockPos pos1, BlockPos pos2) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation) {
    }

    @Override
    public void openShapeToolWindow(BlockPos pos) {
    }

    @Override
    public void openClipBoardWindow(int colonyId) {
    }

    @Override
    public File getSchematicsFolder() {
        return null;
    }

    @Override
    @Nullable
    public World getWorldFromMessage(@NotNull MessageContext context) {
        return context.getServerHandler().field_147369_b.func_71121_q();
    }

    @Override
    @Nullable
    public World getWorld(int dimension) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull EntityPlayer player) {
        return ((EntityPlayerMP)player).func_192037_E();
    }

    @Override
    public void openMultiBlockWindow(BlockPos pos) {
    }

    @Override
    public void initializeOptifine() {
    }
}

