/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placementhandlers;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.blocks.schematic.BlockSolidSubstitution;
import com.ldtteam.structurize.placementhandlers.IPlacementHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlacementHandlers {
    public static final List<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>();

    private PlacementHandlers() {
    }

    public static void handleTileEntityPlacement(NBTTagCompound tileEntityData, World world, @NotNull BlockPos pos, PlacementSettings settings) {
        if (tileEntityData != null) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity == null) {
                TileEntity newTile = TileEntity.func_190200_a((World)world, (NBTTagCompound)tileEntityData);
                if (newTile != null) {
                    newTile.func_189667_a(settings.rotation);
                    newTile.func_189668_a(settings.mirror);
                }
            } else {
                tileEntity.func_145839_a(tileEntityData);
                world.func_175690_a(pos, tileEntity);
                tileEntity.func_189667_a(settings.rotation);
                tileEntity.func_189668_a(settings.mirror);
            }
        }
    }

    public static void handleTileEntityPlacement(NBTTagCompound tileEntityData, World world, @NotNull BlockPos pos) {
        PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, new PlacementSettings());
    }

    public static List<ItemStack> getItemsFromTileEntity(NBTTagCompound tileEntityData, World world) {
        if (tileEntityData != null) {
            return ItemStackUtils.getItemStacksOfTileEntity(tileEntityData, world);
        }
        return Collections.emptyList();
    }

    static {
        handlers.add(new AirPlacementHandler());
        handlers.add(new FirePlacementHandler());
        handlers.add(new GrassPlacementHandler());
        handlers.add(new DoorPlacementHandler());
        handlers.add(new BedPlacementHandler());
        handlers.add(new DoublePlantPlacementHandler());
        handlers.add(new SpecialBlockPlacementAttemptHandler());
        handlers.add(new FlowerPotPlacementHandler());
        handlers.add(new BlockGrassPathPlacementHandler());
        handlers.add(new StairBlockPlacementHandler());
        handlers.add(new ChestPlacementHandler());
        handlers.add(new FallingBlockPlacementHandler());
        handlers.add(new BannerPlacementHandler());
        handlers.add(new BlockSolidSubstitutionPlacementHandler());
        handlers.add(new GeneralBlockPlacementHandler());
    }

    public static class BannerPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockBanner;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.func_180495_p(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return blockState;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class ChestPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockChest;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return blockState;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class GeneralBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return true;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
            if (world.func_180495_p(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
            }
            return blockState;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class StairBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177229_b((IProperty)BlockStairs.field_176309_a) == blockState.func_177229_b((IProperty)BlockStairs.field_176309_a) && blockState.func_177230_c() == world.func_180495_p(pos).func_177230_c();
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class BlockGrassPathPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockGrassPath;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return Blocks.field_150346_d.func_176223_P();
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack(Blocks.field_150346_d, 1));
            return itemList;
        }
    }

    public static class AirPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockAir;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_175623_d(pos)) {
                List entityList = world.func_175647_a(Entity.class, new AxisAlignedBB(pos), entity -> !(entity instanceof EntityLiving) && !(entity instanceof EntityItem));
                if (!entityList.isEmpty()) {
                    for (Entity entity2 : entityList) {
                        entity2.func_70106_y();
                    }
                }
                world.func_175698_g(pos);
            }
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class FlowerPotPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockFlowerPot;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_180501_a(pos, blockState, 3)) {
                return false;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return blockState;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class SpecialBlockPlacementAttemptHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState instanceof BlockEndPortal || blockState instanceof BlockMobSpawner || blockState instanceof BlockDragonEgg || blockState instanceof BlockPortal;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class DoublePlantPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockDoublePlant;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (((BlockDoublePlant.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockDoublePlant.field_176492_b)).equals((Object)BlockDoublePlant.EnumBlockHalf.LOWER)) {
                world.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), 3);
                world.func_180501_a(pos.func_177984_a(), blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 3);
                return blockState;
            }
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            return itemList;
        }
    }

    public static class BedPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockBed;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
                EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockBed.field_185512_D);
                world.func_180501_a(pos.func_177972_a(facing.func_176734_d()), blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 3);
                world.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 3);
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos.func_177972_a(facing.func_176734_d()));
                }
                return blockState;
            }
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
                if (tileEntityData == null) {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    list.add(new ItemStack(Items.field_151104_aV, 1, 14));
                    return list;
                }
                return PlacementHandlers.getItemsFromTileEntity(tileEntityData, world);
            }
            return Collections.emptyList();
        }
    }

    public static class DoorPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockDoor;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) {
                ItemDoor.func_179235_a((World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)), (Block)blockState.func_177230_c(), (boolean)false);
            }
            return blockState;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            return itemList;
        }
    }

    public static class GrassPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() == Blocks.field_150349_c;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_180501_a(pos, Blocks.field_150349_c.func_176223_P(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return Blocks.field_150346_d.func_176223_P();
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack(Blocks.field_150346_d));
            return itemList;
        }
    }

    public static class FallingBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockFalling;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                itemList.add(BlockUtils.getItemStackFromBlockState(BlockUtils.getSubstitutionBlockAtWorld(world, pos)));
            }
            return itemList;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.func_180495_p(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                world.func_180501_a(pos.func_177977_b(), BlockUtils.getSubstitutionBlockAtWorld(world, pos), 3);
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return blockState;
        }
    }

    public static class FirePlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockFire;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack(Items.field_151033_d, 1));
            return itemList;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            world.func_180501_a(pos, blockState, 3);
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }
    }

    public static class BlockSolidSubstitutionPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockSolidSubstitution;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            IBlockState newBlockState = BlockUtils.getSubstitutionBlockAtWorld(world, pos);
            if (complete ? !world.func_180501_a(pos, blockState, 3) : !world.func_180501_a(pos, newBlockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return newBlockState;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            IBlockState newBlockState = BlockUtils.getSubstitutionBlockAtWorld(world, pos);
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(newBlockState));
            return itemList;
        }
    }
}

