/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net.cache;

import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.net.cache.MessageObjectCacheResponse;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class MessageObjectCacheRequest
implements IMessage {
    private int cacheId;
    private int[] ids;
    public static final IMessageHandler<MessageObjectCacheRequest, MessageObjectCacheResponse> HANDLER = (message, ctx) -> {
        NetworkedObjectCache<?> cache = BuildCraftObjectCaches.CACHES.get(message.cacheId);
        byte[][] values = new byte[message.ids.length][];
        PacketBufferBC buffer = new PacketBufferBC(Unpooled.buffer());
        for (int i = 0; i < values.length; ++i) {
            int id = message.ids[i];
            cache.writeObjectServer(id, buffer);
            values[i] = new byte[buffer.readableBytes()];
            buffer.readBytes(values[i]);
            buffer.clear();
        }
        return new MessageObjectCacheResponse(message.cacheId, message.ids, values);
    };

    public MessageObjectCacheRequest() {
    }

    MessageObjectCacheRequest(NetworkedObjectCache<?> cache, int[] ids) {
        this.cacheId = BuildCraftObjectCaches.CACHES.indexOf(cache);
        this.ids = ids;
        if (ids.length > Short.MAX_VALUE) {
            throw new IllegalStateException("Tried to request too many ID's! (" + ids.length + ")");
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.cacheId);
        buf.writeShort(this.ids.length);
        for (int id : this.ids) {
            buf.writeInt(id);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.cacheId = buf.readByte();
        int idCount = buf.readShort();
        this.ids = new int[idCount];
        for (int i = 0; i < idCount; ++i) {
            this.ids[i] = buf.readInt();
        }
    }
}

