/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.reload;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.reload.IReloadable;
import buildcraft.lib.client.reload.ReloadSource;
import buildcraft.lib.client.reload.SourceType;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;

public enum ReloadManager {
    INSTANCE;

    public static final ReloadSource CONFIG_COLOUR_BLIND;
    public static final ReloadSource CONFIG_ROTATE_TRAVEL_ITEMS;
    private final Multimap<ReloadSource, Reloadable> dependencies = HashMultimap.create();
    private final Multimap<Reloadable, ReloadSource> parents = HashMultimap.create();

    public void addDependency(ReloadSource from, IReloadable to, ReloadSource locationTo) {
        Reloadable reloadable = new Reloadable(to, locationTo);
        this.dependencies.put((Object)from, (Object)reloadable);
        this.parents.put((Object)reloadable, (Object)from);
    }

    public void addDependency(ReloadSource from, Runnable to) {
        this.addDependency(from, sources -> {
            to.run();
            return false;
        }, null);
    }

    public void addDependency(ReloadSource from, ReloadSource to) {
        this.addDependency(from, null, to);
    }

    public void preReloadResources() {
        this.dependencies.clear();
        this.parents.clear();
    }

    public void postReload(ReloadSource location) {
        this.postReload((Collection<ReloadSource>)ImmutableList.of((Object)location));
    }

    public void postReload(Collection<ReloadSource> locations) {
        boolean hasChanged;
        HashSet<ReloadSource> allReloadable = new HashSet<ReloadSource>();
        LinkedList<ReloadSource> toVisit = new LinkedList<ReloadSource>(locations);
        while (!toVisit.isEmpty()) {
            Iterator itr = toVisit.iterator();
            ReloadSource s = (ReloadSource)itr.next();
            itr.remove();
            if (!allReloadable.add(s)) continue;
            for (Reloadable r : this.dependencies.get((Object)s)) {
                if (r.source == null) continue;
                toVisit.add(r.source);
            }
        }
        HashSet<ReloadSource> reloaded = new HashSet<ReloadSource>(locations);
        ArrayList<Object> toReload = new ArrayList<Object>();
        HashSet potentialReloadableSet = new HashSet();
        for (ReloadSource loc : locations) {
            potentialReloadableSet.addAll(this.dependencies.get((Object)loc));
        }
        LinkedList potentialReloadables = new LinkedList(potentialReloadableSet);
        do {
            hasChanged = false;
            Iterator potentialItr = potentialReloadables.iterator();
            block4: while (potentialItr.hasNext()) {
                Object r = (Reloadable)potentialItr.next();
                for (ReloadSource parent : this.parents.get(r)) {
                    if (!allReloadable.contains(parent) || reloaded.contains(parent)) continue;
                    continue block4;
                }
                potentialItr.remove();
                toReload.add(r);
            }
            for (Reloadable reloadable : toReload) {
                boolean addChildren = reloadable.reloadable == null ? true : reloadable.reloadable.reload(allReloadable);
                if (reloadable.source == null) continue;
                reloaded.add(reloadable.source);
                if (!addChildren) continue;
                potentialReloadables.addAll(this.dependencies.get((Object)reloadable.source));
                hasChanged = true;
            }
            toReload.clear();
        } while (hasChanged);
        if (potentialReloadables.isEmpty()) {
            return;
        }
        BCLog.logger.fatal("Detected a cyclic dependency chain!");
        BCLog.logger.fatal("Reloadables involved:");
        for (Object r : toReload) {
            BCLog.logger.fatal("  - " + r);
        }
        throw new IllegalStateException("Cyclic dependency chain!");
    }

    private static ReloadSource cfg(String path) {
        return new ReloadSource("buildcraftlib", path, SourceType.CONFIG);
    }

    static {
        CONFIG_COLOUR_BLIND = ReloadManager.cfg("config/colourBlindMode");
        CONFIG_ROTATE_TRAVEL_ITEMS = ReloadManager.cfg("config/rotateTravelingItems");
    }

    private static final class Reloadable {
        final IReloadable reloadable;
        final ReloadSource source;
        final int hash;

        public Reloadable(IReloadable reloadable, ReloadSource source) {
            this.reloadable = reloadable;
            this.source = source;
            this.hash = Objects.hash(reloadable, source);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Reloadable other = (Reloadable)obj;
            return this.reloadable == other.reloadable && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "Reloadable [ " + this.source + " - " + this.reloadable + "  ]";
        }
    }
}

