/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.core.BCCoreConfig;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableLong;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.data.AverageLong;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDistiller_BC8
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    public static final FunctionContext MODEL_FUNC_CTX;
    private static final NodeVariableObject<EnumFacing> MODEL_FACING;
    private static final NodeVariableBoolean MODEL_ACTIVE;
    private static final NodeVariableLong MODEL_POWER_AVG;
    private static final NodeVariableLong MODEL_POWER_MAX;
    public static final IdAllocator IDS;
    public static final int NET_TANK_IN;
    public static final int NET_TANK_GAS_OUT;
    public static final int NET_TANK_LIQUID_OUT;
    public static final long MAX_MJ_PER_TICK;
    private final Tank tankIn = new Tank("in", 4000, this, this::isDistillableFluid);
    private final Tank tankGasOut = new Tank("gasOut", 4000, this);
    private final Tank tankLiquidOut = new Tank("liquidOut", 4000, this);
    private final MjBattery mjBattery = new MjBattery(1024L * MjAPI.MJ);
    public final FluidSmoother smoothedTankIn;
    public final FluidSmoother smoothedTankGasOut;
    public final FluidSmoother smoothedTankLiquidOut;
    public final ModelVariableData clientModelData = new ModelVariableData();
    private IRefineryRecipeManager.IDistillationRecipe currentRecipe;
    private long distillPower = 0L;
    private boolean isActive = false;
    private final AverageLong powerAvg = new AverageLong(100);
    private final SafeTimeTracker updateTracker = new SafeTimeTracker(BCCoreConfig.networkUpdateRate, 2L);
    private boolean changedSinceNetUpdate = true;
    private long powerAvgClient;

    public TileDistiller_BC8() {
        this.tankIn.setCanDrain(false);
        this.tankGasOut.setCanFill(false);
        this.tankLiquidOut.setCanFill(false);
        this.tankManager.add(this.tankIn);
        this.tankManager.add(this.tankGasOut);
        this.tankManager.add(this.tankLiquidOut);
        this.smoothedTankIn = new FluidSmoother(this.createSender(NET_TANK_IN), this.tankIn);
        this.smoothedTankGasOut = new FluidSmoother(this.createSender(NET_TANK_GAS_OUT), this.tankGasOut);
        this.smoothedTankLiquidOut = new FluidSmoother(this.createSender(NET_TANK_LIQUID_OUT), this.tankLiquidOut);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankIn, EnumPipePart.HORIZONTALS);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankGasOut, EnumPipePart.UP);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankLiquidOut, EnumPipePart.DOWN);
        this.caps.addCapabilityInstance(TilesAPI.CAP_HAS_WORK, () -> !this.tankIn.isEmpty(), EnumPipePart.VALUES);
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.mjBattery)));
    }

    private FluidSmoother.IFluidDataSender createSender(int netId) {
        return writer -> this.createAndSendMessage(netId, writer);
    }

    private boolean isDistillableFluid(FluidStack fluid) {
        IRefineryRecipeManager manager = BuildcraftRecipeRegistry.refineryRecipes;
        IRefineryRecipeManager.IDistillationRecipe recipe = manager.getDistillationRegistry().getRecipeForInput(fluid);
        return recipe != null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("tanks", (NBTBase)this.tankManager.serializeNBT());
        nbt.func_74782_a("battery", (NBTBase)this.mjBattery.serializeNBT());
        nbt.func_74772_a("distillPower", this.distillPower);
        this.powerAvg.writeToNbt(nbt, "powerAvg");
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tanksTag = nbt.func_74775_l("tanks");
        if (tanksTag.func_74764_b("out_gas")) {
            tanksTag.func_74782_a("gasOut", tanksTag.func_74781_a("out_gas"));
        }
        if (tanksTag.func_74764_b("out_liquid")) {
            tanksTag.func_74782_a("liquidOut", tanksTag.func_74781_a("out_liquid"));
        }
        super.func_145839_a(nbt);
        this.tankManager.deserializeNBT(nbt.func_74775_l("tanks"));
        if (nbt.func_74764_b("mjBattery")) {
            nbt.func_74782_a("battery", nbt.func_74781_a("mjBattery"));
        }
        this.mjBattery.deserializeNBT(nbt.func_74775_l("battery"));
        this.distillPower = nbt.func_74763_f("distillPower");
        this.powerAvg.readFromNbt(nbt, "powerAvg");
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_TANK_IN, buffer, side);
                this.writePayload(NET_TANK_GAS_OUT, buffer, side);
                this.writePayload(NET_TANK_LIQUID_OUT, buffer, side);
                buffer.writeBoolean(this.isActive);
                this.powerAvgClient = this.powerAvg.getAverageLong();
                long div = MjAPI.MJ / 2L;
                this.powerAvgClient = Math.round((double)this.powerAvgClient / (double)div) * div;
                buffer.writeLong(this.powerAvgClient);
            } else if (id == NET_TANK_IN) {
                this.smoothedTankIn.writeInit(buffer);
            } else if (id == NET_TANK_GAS_OUT) {
                this.smoothedTankGasOut.writeInit(buffer);
            } else if (id == NET_TANK_LIQUID_OUT) {
                this.smoothedTankLiquidOut.writeInit(buffer);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_TANK_IN, buffer, side, ctx);
                this.readPayload(NET_TANK_GAS_OUT, buffer, side, ctx);
                this.readPayload(NET_TANK_LIQUID_OUT, buffer, side, ctx);
                this.smoothedTankIn.resetSmoothing(this.func_145831_w());
                this.smoothedTankGasOut.resetSmoothing(this.func_145831_w());
                this.smoothedTankLiquidOut.resetSmoothing(this.func_145831_w());
                this.isActive = buffer.readBoolean();
                this.powerAvgClient = buffer.readLong();
            } else if (id == NET_TANK_IN) {
                this.smoothedTankIn.handleMessage(this.func_145831_w(), buffer);
            } else if (id == NET_TANK_GAS_OUT) {
                this.smoothedTankGasOut.handleMessage(this.func_145831_w(), buffer);
            } else if (id == NET_TANK_LIQUID_OUT) {
                this.smoothedTankLiquidOut.handleMessage(this.func_145831_w(), buffer);
            }
        }
    }

    public static void setClientModelVariablesForItem() {
        DefaultContexts.RENDER_PARTIAL_TICKS.value = 1.0;
        TileDistiller_BC8.MODEL_ACTIVE.value = false;
        TileDistiller_BC8.MODEL_POWER_AVG.value = 0L;
        TileDistiller_BC8.MODEL_POWER_MAX.value = 6L;
        TileDistiller_BC8.MODEL_FACING.value = EnumFacing.WEST;
    }

    public void setClientModelVariables(float partialTicks) {
        DefaultContexts.RENDER_PARTIAL_TICKS.value = partialTicks;
        TileDistiller_BC8.MODEL_ACTIVE.value = this.isActive;
        TileDistiller_BC8.MODEL_POWER_AVG.value = this.powerAvgClient / MjAPI.MJ;
        TileDistiller_BC8.MODEL_POWER_MAX.value = MAX_MJ_PER_TICK / MjAPI.MJ;
        TileDistiller_BC8.MODEL_FACING.value = EnumFacing.WEST;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BCFactoryBlocks.distiller) {
            TileDistiller_BC8.MODEL_FACING.value = state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        }
    }

    public void func_73660_a() {
        this.smoothedTankIn.tick(this.func_145831_w());
        this.smoothedTankGasOut.tick(this.func_145831_w());
        this.smoothedTankLiquidOut.tick(this.func_145831_w());
        if (this.field_145850_b.field_72995_K) {
            this.setClientModelVariables(1.0f);
            this.clientModelData.tick();
            return;
        }
        this.powerAvg.tick();
        this.changedSinceNetUpdate |= this.powerAvgClient != this.powerAvg.getAverageLong();
        this.currentRecipe = BuildcraftRecipeRegistry.refineryRecipes.getDistillationRegistry().getRecipeForInput(this.tankIn.getFluid());
        if (this.currentRecipe == null) {
            this.mjBattery.addPowerChecking(this.distillPower, false);
            this.distillPower = 0L;
            this.isActive = false;
        } else {
            boolean canFillGas;
            FluidStack reqIn = this.currentRecipe.in();
            FluidStack outLiquid = this.currentRecipe.outLiquid();
            FluidStack outGas = this.currentRecipe.outGas();
            FluidStack potentialIn = this.tankIn.drainInternal(reqIn, false);
            boolean canExtract = reqIn.isFluidStackIdentical(potentialIn);
            boolean canFillLiquid = this.tankLiquidOut.fillInternal(outLiquid, false) == outLiquid.amount;
            boolean bl = canFillGas = this.tankGasOut.fillInternal(outGas, false) == outGas.amount;
            if (canExtract && canFillLiquid && canFillGas) {
                long max = MAX_MJ_PER_TICK;
                max *= this.mjBattery.getStored() + max;
                max /= this.mjBattery.getCapacity() / 2L;
                max = Math.min(max, MAX_MJ_PER_TICK);
                long powerReq = this.currentRecipe.powerRequired();
                long power = this.mjBattery.extractPower(0L, max);
                this.powerAvg.push(max);
                this.distillPower += power;
                boolean bl2 = this.isActive = power > 0L;
                if (this.distillPower >= powerReq) {
                    this.isActive = true;
                    this.distillPower -= powerReq;
                    this.tankIn.drainInternal(reqIn, true);
                    this.tankGasOut.fillInternal(outGas, true);
                    this.tankLiquidOut.fillInternal(outLiquid, true);
                }
            } else {
                this.mjBattery.addPowerChecking(this.distillPower, false);
                this.distillPower = 0L;
                this.isActive = false;
            }
        }
        if (this.changedSinceNetUpdate && this.updateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.powerAvgClient = this.powerAvg.getAverageLong();
            this.sendNetworkUpdate(NET_RENDER_DATA);
            this.changedSinceNetUpdate = false;
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("In = " + this.tankIn.getDebugString());
        left.add("GasOut = " + this.tankGasOut.getDebugString());
        left.add("LiquidOut = " + this.tankLiquidOut.getDebugString());
        left.add("Battery = " + this.mjBattery.getDebugString());
        left.add("Progress = " + MjAPI.formatMj(this.distillPower));
        left.add("Rate = " + LocaleUtil.localizeMjFlow(this.powerAvgClient));
        left.add("CurrRecipe = " + this.currentRecipe);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getClientDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        this.setClientModelVariables(1.0f);
        left.add("Model Variables:");
        left.add("  facing = " + TileDistiller_BC8.MODEL_FACING.value);
        left.add("  active = " + TileDistiller_BC8.MODEL_ACTIVE.value);
        left.add("  power_average = " + TileDistiller_BC8.MODEL_POWER_AVG.value);
        left.add("  power_max = " + TileDistiller_BC8.MODEL_POWER_MAX.value);
        left.add("Current Model Variables:");
        this.clientModelData.refresh();
        this.clientModelData.addDebugInfo(left);
    }

    static {
        IDS = TileBC_Neptune.IDS.makeChild("Distiller");
        NET_TANK_IN = IDS.allocId("TANK_IN");
        NET_TANK_GAS_OUT = IDS.allocId("TANK_GAS_OUT");
        NET_TANK_LIQUID_OUT = IDS.allocId("TANK_LIQUID_OUT");
        MODEL_FUNC_CTX = DefaultContexts.createWithAll();
        MODEL_FACING = MODEL_FUNC_CTX.putVariableObject("direction", EnumFacing.class);
        MODEL_POWER_AVG = MODEL_FUNC_CTX.putVariableLong("power_average");
        MODEL_POWER_MAX = MODEL_FUNC_CTX.putVariableLong("power_max");
        MODEL_ACTIVE = MODEL_FUNC_CTX.putVariableBoolean("active");
        MAX_MJ_PER_TICK = 6L * MjAPI.MJ;
    }
}

