/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import java.util.Locale;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionMachineControl
extends BCStatement
implements IActionExternal {
    public final IControllable.Mode mode;

    public ActionMachineControl(IControllable.Mode mode) {
        super("buildcraft:machine." + mode.name().toLowerCase(Locale.ROOT), "buildcraft.machine." + mode.name().toLowerCase(Locale.ROOT));
        this.mode = mode;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.action.machine." + this.mode.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public void actionActivate(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        IControllable controllable = (IControllable)target.getCapability(TilesAPI.CAP_CONTROLLABLE, side.func_176734_d());
        if (controllable != null && controllable.acceptsControlMode(this.mode)) {
            controllable.setControlMode(this.mode);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCCoreSprites.ACTION_MACHINE_CONTROL.get((Object)this.mode);
    }

    @Override
    public IStatement[] getPossible() {
        return BCCoreStatements.ACTION_MACHINE_CONTROL;
    }
}

