/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public enum EnumWirePart {
    EAST_UP_SOUTH(true, true, true),
    EAST_UP_NORTH(true, true, false),
    EAST_DOWN_SOUTH(true, false, true),
    EAST_DOWN_NORTH(true, false, false),
    WEST_UP_SOUTH(false, true, true),
    WEST_UP_NORTH(false, true, false),
    WEST_DOWN_SOUTH(false, false, true),
    WEST_DOWN_NORTH(false, false, false);

    public static final EnumWirePart[] VALUES;
    public final EnumFacing.AxisDirection x;
    public final EnumFacing.AxisDirection y;
    public final EnumFacing.AxisDirection z;
    public final AxisAlignedBB boundingBox;
    public final AxisAlignedBB boundingBoxPossible;

    private EnumWirePart(boolean x, boolean y, boolean z) {
        this.x = x ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE;
        this.y = y ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE;
        this.z = z ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE;
        double x1 = (double)this.x.func_179524_a() * 0.3125 + 0.5;
        double y1 = (double)this.y.func_179524_a() * 0.3125 + 0.5;
        double z1 = (double)this.z.func_179524_a() * 0.3125 + 0.5;
        double x2 = (double)this.x.func_179524_a() * 0.25 + 0.5;
        double y2 = (double)this.y.func_179524_a() * 0.25 + 0.5;
        double z2 = (double)this.z.func_179524_a() * 0.25 + 0.5;
        this.boundingBox = new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
        Vec3d center = new Vec3d(0.5, 0.5, 0.5);
        Vec3d edge = new Vec3d(x ? 0.75 : 0.25, y ? 0.75 : 0.25, z ? 0.75 : 0.25);
        this.boundingBoxPossible = new AxisAlignedBB(center.field_72450_a, center.field_72448_b, center.field_72449_c, edge.field_72450_a, edge.field_72448_b, edge.field_72449_c);
    }

    public EnumFacing.AxisDirection getDirection(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        return null;
    }

    public static EnumWirePart get(int x, int y, int z) {
        boolean bx = (x % 2 + 2) % 2 == 1;
        boolean by = (y % 2 + 2) % 2 == 1;
        boolean bz = (z % 2 + 2) % 2 == 1;
        return EnumWirePart.get(bx, by, bz);
    }

    public static EnumWirePart get(boolean x, boolean y, boolean z) {
        if (x) {
            if (y) {
                return z ? EAST_UP_SOUTH : EAST_UP_NORTH;
            }
            return z ? EAST_DOWN_SOUTH : EAST_DOWN_NORTH;
        }
        if (y) {
            return z ? WEST_UP_SOUTH : WEST_UP_NORTH;
        }
        return z ? WEST_DOWN_SOUTH : WEST_DOWN_NORTH;
    }

    static {
        VALUES = EnumWirePart.values();
    }
}

