/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilitiesHelper {
    private static final IdentityHashMap<?, ?> __FIELD_CAP_MANAGER_PROVIDERS;

    @Nonnull
    public static <T> Capability<T> registerCapability(Class<T> clazz) {
        return CapabilitiesHelper.registerCapability(new ThrowingStorage<T>(clazz), () -> {
            throw new UnsupportedOperationException("You must create your own instances!");
        });
    }

    @Nonnull
    public static <T> Capability<T> registerCapability(CheckedStorage<T> storage, Callable<T> factory) {
        return CapabilitiesHelper.registerCapInternal(storage, factory);
    }

    @Nonnull
    private static <T> Capability<T> registerCapInternal(CheckedStorage<T> storage, Callable<T> factory) {
        Class clazz = storage.clazz;
        CapabilityManager.INSTANCE.register(clazz, storage, factory);
        String fullName = clazz.getName().intern();
        Object obj = __FIELD_CAP_MANAGER_PROVIDERS.get(fullName);
        if (obj == null) {
            throw new IllegalStateException("Apparently we didn't register the capability? How?");
        }
        if (!(obj instanceof Capability)) {
            throw new Error("We must have the wrong map! providers.get(key) returned " + obj.getClass() + " rather than " + Capability.class);
        }
        Capability cap = (Capability)obj;
        Capability.IStorage cStorage = cap.getStorage();
        if (!(cStorage instanceof CheckedStorage)) {
            throw new IllegalStateException("Returned capability storage has a different storage class than expected! " + cStorage.getClass());
        }
        CheckedStorage vStorage = (CheckedStorage)cStorage;
        if (vStorage.clazz != clazz) {
            throw new IllegalStateException("Returned capability storage has a different class than expected! " + vStorage.clazz + " vs " + clazz);
        }
        return cap;
    }

    @Nonnull
    @Deprecated
    public static <T> Capability<T> ensureRegistration(Capability<T> cap, Class<T> clazz) {
        if (cap == null) {
            throw new Error("Capability registration failed for " + clazz);
        }
        return cap;
    }

    static {
        try {
            Field fld = CapabilityManager.class.getDeclaredField("providers");
            fld.setAccessible(true);
            Object obj = fld.get(CapabilityManager.INSTANCE);
            __FIELD_CAP_MANAGER_PROVIDERS = (IdentityHashMap)obj;
            if (__FIELD_CAP_MANAGER_PROVIDERS == null) {
                throw new Error("Couldn't find providers!");
            }
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    public static class VoidStorage<T>
    implements Capability.IStorage<T> {
        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            throw new IllegalStateException("You must create your own instances!");
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            throw new IllegalStateException("You must create your own instances!");
        }
    }

    public static final class ThrowingStorage<T>
    extends CheckedStorage<T> {
        public ThrowingStorage(Class<T> clazz) {
            super(clazz);
        }

        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            throw new UnsupportedOperationException("You must create your own instances!");
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            throw new UnsupportedOperationException("You must create your own instances!");
        }
    }

    public static abstract class CheckedStorage<T>
    implements Capability.IStorage<T> {
        public final Class<T> clazz;

        public CheckedStorage(Class<T> clazz) {
            this.clazz = clazz;
        }
    }
}

