/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.IconUtil;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.DrawerStateModelData;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.MaterialModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import com.jaquadro.minecraft.storagedrawers.client.model.dynamic.CommonDrawerRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CustomDrawerModel
extends ChamModel {
    private static final int[] iconIndex = new int[]{0, 0, 1, 0, 2};
    private TextureAtlasSprite iconParticle;
    private static final ItemHandler itemHandler = new ItemHandler();

    public static IBakedModel fromBlock(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return new CustomDrawerModel(state, false);
        }
        IExtendedBlockState xstate = (IExtendedBlockState)state;
        DrawerStateModelData stateModel = (DrawerStateModelData)((Object)xstate.getValue(BlockDrawers.STATE_MODEL));
        MaterialModelData matModel = (MaterialModelData)((Object)xstate.getValue(BlockDrawersCustom.MAT_MODEL));
        if (stateModel == null || matModel == null) {
            return new CustomDrawerModel(state, false);
        }
        ItemStack effMatFront = matModel.getEffectiveMaterialFront();
        ItemStack effMatSide = matModel.getEffectiveMaterialSide();
        ItemStack effMatTrim = matModel.getEffectiveMaterialTrim();
        ItemStack matFront = matModel.getMaterialFront();
        ItemStack matSide = matModel.getMaterialSide();
        ItemStack matTrim = matModel.getMaterialTrim();
        return new CustomDrawerModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, false);
    }

    public static IBakedModel fromItem(@Nonnull ItemStack stack) {
        IBlockState state = ModBlocks.customDrawers.func_176203_a(stack.func_77960_j());
        if (!stack.func_77942_o()) {
            return new CustomDrawerModel(state, true);
        }
        NBTTagCompound tag = stack.func_77978_p();
        ItemStack matFront = ItemStack.field_190927_a;
        ItemStack matSide = ItemStack.field_190927_a;
        ItemStack matTrim = ItemStack.field_190927_a;
        if (tag.func_150297_b("MatF", 10)) {
            matFront = new ItemStack(tag.func_74775_l("MatF"));
        }
        if (tag.func_150297_b("MatS", 10)) {
            matSide = new ItemStack(tag.func_74775_l("MatS"));
        }
        if (tag.func_150297_b("MatT", 10)) {
            matTrim = new ItemStack(tag.func_74775_l("MatT"));
        }
        ItemStack effMatFront = !matFront.func_190926_b() ? matFront : matSide;
        ItemStack effMatTrim = !matTrim.func_190926_b() ? matTrim : matSide;
        ItemStack effMatSide = matSide;
        CustomDrawerModel model = new CustomDrawerModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, true);
        if (!stack.func_77978_p().func_150297_b("tile", 10)) {
            return model;
        }
        return new DrawerSealedModel((IBakedModel)model, state, true);
    }

    private CustomDrawerModel(IBlockState state, boolean mergeLayers) {
        this(state, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, mergeLayers);
    }

    private CustomDrawerModel(IBlockState state, @Nonnull ItemStack effMatFront, @Nonnull ItemStack effMatSide, @Nonnull ItemStack effMatTrim, @Nonnull ItemStack matFront, @Nonnull ItemStack matSide, @Nonnull ItemStack matTrim, boolean mergeLayers) {
        super(state, mergeLayers, new Object[]{effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim});
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconTrim;
        EnumBasicDrawer info = (EnumBasicDrawer)((Object)state.func_177229_b(BlockStandardDrawers.BLOCK));
        int index = iconIndex[info.getDrawerCount()];
        ItemStack itemFront = (ItemStack)args[0];
        ItemStack itemSide = (ItemStack)args[1];
        ItemStack itemTrim = (ItemStack)args[2];
        TextureAtlasSprite iconFront = !itemFront.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemFront) : null;
        TextureAtlasSprite iconSide = !itemSide.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemSide) : null;
        TextureAtlasSprite textureAtlasSprite = iconTrim = !itemTrim.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTrim) : null;
        if (iconFront == null) {
            iconFront = iconSide;
        }
        if (iconTrim == null) {
            iconTrim = iconSide;
        }
        if (iconFront == null) {
            iconFront = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultFront[index]);
        }
        if (iconSide == null) {
            iconSide = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTrim == null) {
            iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        this.iconParticle = iconSide;
        CommonDrawerRenderer drawerRenderer = new CommonDrawerRenderer(renderer);
        drawerRenderer.renderBasePass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconSide, iconTrim, iconFront);
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumBasicDrawer info = (EnumBasicDrawer)((Object)state.func_177229_b(BlockStandardDrawers.BLOCK));
        int index = iconIndex[info.getDrawerCount()];
        TextureAtlasSprite iconOverlayFace = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayFace[index]);
        TextureAtlasSprite iconOverlayHandle = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayHandle[index]);
        ItemStack itemTrim = (ItemStack)args[5];
        TextureAtlasSprite iconTrim = !itemTrim.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTrim) : null;
        TextureAtlasSprite iconOverlayTrim = iconTrim == null ? Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayBoldTrim[index]) : Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayTrim[index]);
        CommonDrawerRenderer drawerRenderer = new CommonDrawerRenderer(renderer);
        drawerRenderer.renderOverlayPass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconOverlayTrim, iconOverlayHandle, iconOverlayFace);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            return CustomDrawerModel.fromItem(stack);
        }
    }

    public static class Register
    extends DefaultRegister {
        public static final ResourceLocation iconDefaultSide = new ResourceLocation("storagedrawers:blocks/drawers_raw_side");
        public static final ResourceLocation[] iconDefaultFront = new ResourceLocation[]{new ResourceLocation("storagedrawers:blocks/drawers_raw_front_1"), new ResourceLocation("storagedrawers:blocks/drawers_raw_front_2"), new ResourceLocation("storagedrawers:blocks/drawers_raw_front_4")};
        public static final ResourceLocation[] iconOverlayTrim = new ResourceLocation[]{new ResourceLocation("storagedrawers:blocks/overlay/shading_trim_1"), new ResourceLocation("storagedrawers:blocks/overlay/shading_trim_2"), new ResourceLocation("storagedrawers:blocks/overlay/shading_trim_4")};
        public static final ResourceLocation[] iconOverlayBoldTrim = new ResourceLocation[]{new ResourceLocation("storagedrawers:blocks/overlay/shading_boldtrim_1"), new ResourceLocation("storagedrawers:blocks/overlay/shading_boldtrim_2"), new ResourceLocation("storagedrawers:blocks/overlay/shading_boldtrim_4")};
        public static final ResourceLocation[] iconOverlayFace = new ResourceLocation[]{new ResourceLocation("storagedrawers:blocks/overlay/shading_face_1"), new ResourceLocation("storagedrawers:blocks/overlay/shading_face_2"), new ResourceLocation("storagedrawers:blocks/overlay/shading_face_4")};
        public static final ResourceLocation[] iconOverlayHandle = new ResourceLocation[]{new ResourceLocation("storagedrawers:blocks/overlay/handle_1"), new ResourceLocation("storagedrawers:blocks/overlay/handle_2"), new ResourceLocation("storagedrawers:blocks/overlay/handle_4")};

        public Register() {
            super((Block)ModBlocks.customDrawers);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumBasicDrawer drawer : EnumBasicDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(ModBlocks.customDrawers.func_176223_P().func_177226_a(BlockStandardDrawers.BLOCK, (Comparable)((Object)drawer)).func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(iconDefaultSide);
            resource.addAll(Arrays.asList(iconDefaultFront));
            resource.addAll(Arrays.asList(iconOverlayTrim));
            resource.addAll(Arrays.asList(iconOverlayBoldTrim));
            resource.addAll(Arrays.asList(iconOverlayFace));
            resource.addAll(Arrays.asList(iconOverlayHandle));
            return resource;
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            IBakedModel mainModel = CustomDrawerModel.fromBlock(state);
            if (!(state instanceof IExtendedBlockState)) {
                return mainModel;
            }
            IExtendedBlockState xstate = (IExtendedBlockState)state;
            DrawerStateModelData stateModel = (DrawerStateModelData)((Object)xstate.getValue(BlockDrawers.STATE_MODEL));
            try {
                if (!DrawerDecoratorModel.shouldHandleState(stateModel)) {
                    return mainModel;
                }
                EnumBasicDrawer drawer = (EnumBasicDrawer)((Object)state.func_177229_b(BlockStandardDrawers.BLOCK));
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
                DrawerDecoratorModel decModel = new DrawerDecoratorModel(mainModel, xstate, drawer, dir, stateModel);
                decModel.addBaseRenderLayer(BlockRenderLayer.TRANSLUCENT);
                return decModel;
            }
            catch (Throwable t) {
                try {
                    return mainModel;
                }
                catch (Throwable t2) {
                    return parent;
                }
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                IExtendedBlockState xstate = (IExtendedBlockState)state;
                key.add(xstate.getValue(BlockDrawers.STATE_MODEL));
                key.add(xstate.getValue(BlockDrawersCustom.MAT_MODEL));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }
}

