/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.chameleon.block.ChamTileEntity;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;

public class TileEntitySlave
extends ChamTileEntity
implements IDrawerGroup {
    private static final int[] drawerSlots = new int[]{0};
    public final ControllerData controllerData = new ControllerData();
    @CapabilityInject(value=IItemHandler.class)
    static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IItemRepository.class)
    static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    @CapabilityInject(value=IDrawerGroup.class)
    static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = null;
    private DrawerItemHandler itemHandler = new DrawerItemHandler(this);
    private ItemRepositoryProxy itemRepository = new ItemRepositoryProxy();

    public TileEntitySlave() {
        this.injectData(this.controllerData);
    }

    public void bindController(BlockPos coord) {
        if (this.controllerData.bindCoord(coord)) {
            this.func_70296_d();
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerData.getCoord();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public TileEntityController getController() {
        return this.controllerData.getController((TileEntity)this);
    }

    @Override
    @Nonnull
    public int[] getAccessibleDrawerSlots() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    @Override
    public int getDrawerCount() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    @Nonnull
    public IDrawer getDrawer(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return Drawers.DISABLED;
        }
        return controller.getDrawer(slot);
    }

    public void func_70296_d() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.func_174877_v())) {
            controller.func_70296_d();
        }
        super.func_70296_d();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ITEM_HANDLER_CAPABILITY && StorageDrawers.config.allowControllerIO() || capability == ITEM_REPOSITORY_CAPABILITY || capability == DRAWER_GROUP_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ITEM_HANDLER_CAPABILITY && StorageDrawers.config.allowControllerIO()) {
            return (T)this.itemHandler;
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return (T)this.itemRepository;
        }
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    private class ItemRepositoryProxy
    implements IItemRepository {
        private ItemRepositoryProxy() {
        }

        @Override
        @Nonnull
        public NonNullList<IItemRepository.ItemRecord> getAllItems() {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.func_174877_v())) {
                return NonNullList.func_191196_a();
            }
            return controller.getItemRepository().getAllItems();
        }

        @Override
        @Nonnull
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.func_174877_v())) {
                return stack;
            }
            return controller.getItemRepository().insertItem(stack, simulate, predicate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(@Nonnull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.func_174877_v())) {
                return ItemStack.field_190927_a;
            }
            return controller.getItemRepository().extractItem(stack, amount, simulate, predicate);
        }

        @Override
        public int getStoredItemCount(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.func_174877_v())) {
                return 0;
            }
            return controller.getItemRepository().getStoredItemCount(stack, predicate);
        }

        @Override
        public int getRemainingItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.func_174877_v())) {
                return 0;
            }
            return controller.getItemRepository().getRemainingItemCapacity(stack, predicate);
        }

        @Override
        public int getItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.func_174877_v())) {
                return 0;
            }
            return controller.getItemRepository().getItemCapacity(stack, predicate);
        }
    }
}

