/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.item.functional.PowerModItem;
import com.cjm721.overloaded.network.packets.RailGunFireMessage;
import com.cjm721.overloaded.network.packets.RailGunSettingsMessage;
import com.cjm721.overloaded.storage.GenericDataStorage;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import com.cjm721.overloaded.storage.itemwrapper.GenericDataCapabilityProviderWrapper;
import com.cjm721.overloaded.util.WorldUtil;
import com.google.common.primitives.Ints;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemRailGun
extends PowerModItem {
    @Nonnull
    private static final String RAILGUN_POWER_KEY = "railgun.power";

    public ItemRailGun() {
        this.setRegistryName("railgun");
        this.func_77655_b("railgun");
        this.func_77637_a(OverloadedCreativeTabs.TECH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IGenericDataStorage cap = (IGenericDataStorage)stack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE, null);
        if (cap != null) {
            cap.suggestUpdate();
            int energyRequirement = cap.getIntegerMap().getOrDefault(RAILGUN_POWER_KEY, Overloaded.cachedConfig.railGun.minEngery);
            tooltip.add(String.format("Power Usage: %s", NumberFormat.getInstance().format(energyRequirement)));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "railgun"), null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/items/railgun.png"), Overloaded.cachedConfig.textureResolutions.itemResolution);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (worldIn.field_72995_K) {
            RayTraceResult ray = WorldUtil.rayTraceWithEntities(worldIn, playerIn.func_174824_e(1.0f), playerIn.func_70676_i(1.0f), (Entity)playerIn, Overloaded.cachedConfig.railGun.maxRange);
            if (ray != null && ray.field_72308_g != null) {
                Vec3d moveVev = playerIn.func_174824_e(1.0f).func_178788_d(ray.field_72307_f).func_72432_b().func_186678_a(-1.0);
                RailGunFireMessage message = new RailGunFireMessage(ray.field_72308_g.func_145782_y(), moveVev, handIn);
                Overloaded.proxy.networkWrapper.sendToServer((IMessage)message);
            } else {
                RailGunFireMessage message = new RailGunFireMessage(0, Vec3d.field_186680_a, handIn);
                Overloaded.proxy.networkWrapper.sendToServer((IMessage)message);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(@Nonnull MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getDwheel() != 0 && player != null && player.func_70093_af()) {
            ItemStack stack = player.func_184614_ca();
            if (player.func_70093_af() && !stack.func_190926_b() && stack.func_77973_b() == this) {
                int powerDelta = Integer.signum(event.getDwheel()) * Overloaded.cachedConfig.railGun.stepEnergy;
                if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                    powerDelta *= 100;
                }
                RailGunSettingsMessage message = new RailGunSettingsMessage(powerDelta);
                Overloaded.proxy.networkWrapper.sendToServer((IMessage)message);
                event.setCanceled(true);
            }
        }
    }

    public void handleFireMessage(@Nonnull EntityPlayerMP player, @Nonnull RailGunFireMessage message) {
        ItemStack itemStack = player.func_184586_b(message.hand);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        IGenericDataStorage settingCapability = (IGenericDataStorage)itemStack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE, null);
        settingCapability.suggestUpdate();
        int energyRequired = settingCapability.getIntegerMap().getOrDefault(RAILGUN_POWER_KEY, Overloaded.cachedConfig.railGun.minEngery);
        if (energy.getEnergyStored() < energyRequired) {
            player.func_146105_b((ITextComponent)new TextComponentString("Not enough power to fire."), true);
            return;
        }
        int energyExtracted = energy.extractEnergy(energyRequired, false);
        Entity entity = player.field_70170_p.func_73045_a(message.id);
        if (entity == null || entity.field_70128_L) {
            return;
        }
        if (player.func_70032_d(entity) > (float)Overloaded.cachedConfig.rayGun.maxRange) {
            player.func_146105_b((ITextComponent)new TextComponentString("Target out of range."), true);
        } else if (entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), Overloaded.cachedConfig.railGun.damagePerRF * (float)energyExtracted)) {
            Vec3d knockback = message.moveVector.func_186678_a((double)((float)energyExtracted * Overloaded.cachedConfig.railGun.knockbackPerRF));
            entity.func_70024_g(knockback.field_72450_a, knockback.field_72448_b, knockback.field_72449_c);
        }
    }

    @Override
    public Collection<ICapabilityProvider> collectCapabilities(@Nonnull Collection<ICapabilityProvider> collection, ItemStack stack, @Nullable NBTTagCompound nbt) {
        collection.add(new GenericDataCapabilityProviderWrapper(stack));
        return super.collectCapabilities(collection, stack, nbt);
    }

    public void handleSettingsMessage(@Nonnull EntityPlayerMP player, @Nonnull RailGunSettingsMessage message) {
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        IGenericDataStorage cap = (IGenericDataStorage)itemStack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE, null);
        Map<String, Integer> integerMap = cap.getIntegerMap();
        int power = integerMap.getOrDefault(RAILGUN_POWER_KEY, 0) + message.powerDelta;
        power = Ints.constrainToRange((int)power, (int)Overloaded.cachedConfig.railGun.minEngery, (int)Overloaded.cachedConfig.railGun.maxEnergy);
        integerMap.put(RAILGUN_POWER_KEY, power);
        cap.suggestSave();
        player.func_146105_b((ITextComponent)new TextComponentString("Power usage set to: " + NumberFormat.getInstance().format(power)), true);
    }
}

