/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.api.typeadapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import p455w0rdslib.api.typeadapters.WrappedBlockState;

public class WrappedBlockStateAdapter
implements JsonSerializer<WrappedBlockState>,
JsonDeserializer<WrappedBlockState> {
    private static final String KEY_NAME = "name";
    private static final String KEY_PROPERTIES = "properties";

    public JsonElement serialize(WrappedBlockState src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add(KEY_NAME, context.serialize((Object)src.getName()));
        Map<String, String> properties = src.getProperties();
        if (properties != null && !properties.isEmpty()) {
            result.add(KEY_PROPERTIES, context.serialize(properties, Types.MAP_STRING_STRING));
        }
        return result;
    }

    public WrappedBlockState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        ResourceLocation name = (ResourceLocation)context.deserialize(jsonObject.get(KEY_NAME), ResourceLocation.class);
        Map properties = jsonObject.has(KEY_PROPERTIES) ? (Map)context.deserialize(jsonObject.get(KEY_PROPERTIES), Types.MAP_STRING_STRING) : null;
        return new WrappedBlockState(name, properties);
    }

    public static final class Types {
        public static final Type LIST_STRING = new TypeToken<List<String>>(){}.getType();
        public static final Type MAP_STRING_STRING = new TypeToken<Map<String, String>>(){}.getType();

        private Types() {
        }
    }
}

