/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.items;

import forestry.api.climate.IClimateHousing;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.core.climate.ClimateRoot;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHabitatScreen
extends ItemForestry
implements IColoredItem {
    public static final String POSITION_KEY = "greenhouse";
    public static final String DIMENSION_KEY = "dimension";
    public static final String PREVIEW_KEY = "preview";

    public static boolean isPreviewModeActive(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null || !nbtTagCompound.func_74764_b(PREVIEW_KEY)) {
            return false;
        }
        return nbtTagCompound.func_74767_n(PREVIEW_KEY);
    }

    public static void setPreviewMode(ItemStack itemStack, boolean preview) {
        itemStack.func_77983_a(PREVIEW_KEY, (NBTBase)new NBTTagByte((byte)(preview ? 1 : 0)));
    }

    @Nullable
    public static BlockPos getPosition(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null || !nbtTagCompound.func_74764_b(POSITION_KEY)) {
            return null;
        }
        NBTTagCompound compound = nbtTagCompound.func_74775_l(POSITION_KEY);
        if (compound.func_82582_d()) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)compound);
    }

    public static int getDimension(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null || !nbtTagCompound.func_74764_b(DIMENSION_KEY)) {
            return Integer.MAX_VALUE;
        }
        return nbtTagCompound.func_74762_e(DIMENSION_KEY);
    }

    public static boolean isValid(ItemStack stack, @Nullable World world) {
        BlockPos pos = ItemHabitatScreen.getPosition(stack);
        int dimension = ItemHabitatScreen.getDimension(stack);
        if (pos == null || world == null || dimension == Integer.MAX_VALUE || dimension != world.field_73011_w.getDimension() || !world.func_175667_e(pos)) {
            return false;
        }
        return TileUtil.getTile((IBlockAccess)world, pos, IClimateHousing.class) != null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            boolean previewModeActive = ItemHabitatScreen.isPreviewModeActive(itemStack);
            ItemHabitatScreen.setPreviewMode(itemStack, !previewModeActive);
            if (!world.field_72995_K) {
                String text = !previewModeActive ? "for.habitat_screen.mode.active" : "for.habitat_screen.mode.inactive";
                player.func_146105_b((ITextComponent)new TextComponentTranslation(text, new Object[0]), true);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IClimateHousing housing;
        if (player.func_70093_af() && (housing = TileUtil.getTile((IBlockAccess)world, pos, IClimateHousing.class)) != null) {
            ItemStack heldItem = player.func_184586_b(hand);
            heldItem.func_77983_a(POSITION_KEY, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            heldItem.func_77983_a(DIMENSION_KEY, (NBTBase)new NBTTagInt(world.field_73011_w.getDimension()));
        }
        if (!world.field_72995_K) {
            IClimateState state;
            IClimateState climateState = ClimateRoot.getInstance().getState(world, pos);
            if (climateState.isPresent()) {
                state = climateState;
                if (!state.isPresent()) {
                    state = ClimateRoot.getInstance().getBiomeState(world, pos);
                }
            } else {
                state = ClimateRoot.getInstance().getBiomeState(world, pos);
            }
            if (state.isPresent()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("for.habitat_screen.status.state", new Object[]{TextFormatting.GOLD.toString() + StringUtil.floatAsPercent(state.getTemperature()), TextFormatting.BLUE.toString() + StringUtil.floatAsPercent(state.getHumidity())}), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("for.habitat_screen.status.nostate", new Object[0]), true);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (world == null) {
            return;
        }
        boolean previewModeActive = ItemHabitatScreen.isPreviewModeActive(stack);
        tooltip.add(Translator.translateToLocal(previewModeActive ? "for.habitat_screen.mode.active" : "for.habitat_screen.mode.inactive"));
        boolean isValid = ItemHabitatScreen.isValid(stack, world);
        BlockPos pos = ItemHabitatScreen.getPosition(stack);
        if (pos != null) {
            String state = isValid ? Translator.translateToLocalFormatted("for.habitat_screen.state.linked", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73011_w.getDimension()) : Translator.translateToLocal("for.habitat_screen.state.fail");
            tooltip.add(state);
        }
        if (!isValid || pos == null) {
            return;
        }
        IClimateHousing housing = TileUtil.getTile((IBlockAccess)world, pos, IClimateHousing.class);
        if (housing == null) {
            return;
        }
        IClimateState climateState = housing.getTransformer().getCurrent();
        tooltip.add(Translator.translateToLocalFormatted("for.habitat_screen.temperature", TextFormatting.GOLD + StringUtil.floatAsPercent(climateState.getTemperature())));
        tooltip.add(Translator.translateToLocalFormatted("for.habitat_screen.humidity", TextFormatting.BLUE + StringUtil.floatAsPercent(climateState.getHumidity())));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        if (tintIndex == 2) {
            return ItemHabitatScreen.isValid(stack, (World)Minecraft.func_71410_x().field_71441_e) ? 1356406 : 12197655;
        }
        if (tintIndex == 1) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (!ItemHabitatScreen.isValid(stack, (World)world)) {
                return 0xFFFFFF;
            }
            BlockPos pos = ItemHabitatScreen.getPosition(stack);
            if (pos == null) {
                return 0xFFFFFF;
            }
            IClimateHousing housing = TileUtil.getTile((IBlockAccess)world, pos, IClimateHousing.class);
            if (housing == null) {
                return 0xFFFFFF;
            }
            IClimateTransformer transformer = housing.getTransformer();
            IClimateState state = transformer.getCurrent();
            return state.getTemperatureEnum().color;
        }
        return 0xFFFFFF;
    }
}

