/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.data.PlaneShape;
import cofh.cofhworld.data.numbers.ConstantProvider;
import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.data.numbers.random.UniformRandomProvider;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.generator.WorldGen;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenMinablePlate
extends WorldGen {
    private final List<WeightedBlock> cluster;
    private final WeightedBlock[] genBlock;
    private final INumberProvider radius;
    private INumberProvider height;
    private PlaneShape shape = PlaneShape.CIRCLE;
    private boolean slim;

    public WorldGenMinablePlate(List<WeightedBlock> resource, int clusterSize, List<WeightedBlock> block) {
        this(resource, new UniformRandomProvider(clusterSize, clusterSize + 2), block);
    }

    public WorldGenMinablePlate(List<WeightedBlock> resource, INumberProvider clusterSize, List<WeightedBlock> block) {
        this.cluster = resource;
        this.radius = clusterSize;
        this.genBlock = block.toArray(new WeightedBlock[block.size()]);
        this.setHeight(1).setSlim(false);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        INumberProvider.DataHolder data = new INumberProvider.DataHolder(pos);
        ++y;
        int size = this.radius.intValue(world, rand, data);
        PlaneShape shape = this.shape;
        int height = this.height.intValue(world, rand, data);
        boolean r = false;
        for (int posX = x - size; posX <= x + size; ++posX) {
            int areaX = posX - x;
            for (int posZ = z - size; posZ <= z + size; ++posZ) {
                int areaZ = posZ - z;
                if (!shape.inArea(areaX, areaZ, size)) continue;
                int posY = y - height;
                while (this.slim ? posY < y + height : posY <= y + height) {
                    r |= WorldGenMinablePlate.generateBlock(world, rand, posX, posY, posZ, this.genBlock, this.cluster);
                    ++posY;
                }
            }
        }
        return r;
    }

    public WorldGenMinablePlate setSlim(boolean slim) {
        this.slim = slim;
        return this;
    }

    public WorldGenMinablePlate setShape(PlaneShape shape) {
        this.shape = shape;
        return this;
    }

    public WorldGenMinablePlate setHeight(int height) {
        this.height = new ConstantProvider(height);
        return this;
    }

    public WorldGenMinablePlate setHeight(INumberProvider height) {
        this.height = height;
        return this;
    }
}

