/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.world.distribution.Distribution;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DistributionLargeVein
extends Distribution {
    private final WorldGenerator worldGen;
    private final INumberProvider count;
    private final INumberProvider minY;
    private INumberProvider veinHeight;
    private INumberProvider veinDiameter;
    private INumberProvider verticalDensity;
    private INumberProvider horizontalDensity;

    public DistributionLargeVein(String name, WorldGenerator worldGen, INumberProvider count, INumberProvider minY, boolean regen, INumberProvider height, INumberProvider diameter, INumberProvider vDensity, INumberProvider hDensity) {
        super(name, regen);
        this.worldGen = worldGen;
        this.count = count;
        this.minY = minY;
        this.veinHeight = height;
        this.veinDiameter = diameter;
        this.verticalDensity = vDensity;
        this.horizontalDensity = hDensity;
    }

    public int getDensity(Random rand, int oreDistance, float oreDensity) {
        int i = (int)(oreDensity = oreDensity * 0.01f * (float)(oreDistance >> 1));
        if (i == 0) {
            ++i;
        }
        int rnd = oreDistance / i;
        int r = 0;
        while (i > 0) {
            r += rand.nextInt(rnd);
            --i;
        }
        return r;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        INumberProvider.DataHolder data = new INumberProvider.DataHolder(pos);
        int veinDiameter = this.veinDiameter.intValue(world, random, data);
        int horizontalDensity = this.horizontalDensity.intValue(world, random, data);
        int veinHeight = this.veinHeight.intValue(world, random, data);
        int verticalDensity = this.verticalDensity.intValue(world, random, data);
        int blockY = this.minY.intValue(world, random, data);
        int count = this.count.intValue(world, random, data);
        Random dRand = new Random(world.func_72905_C());
        long l = dRand.nextLong() / 2L * 2L + 1L;
        long l1 = dRand.nextLong() / 2L * 2L + 1L;
        dRand.setSeed((long)(blockX >> 4) * l + (long)(blockZ >> 4) * l1 ^ world.func_72905_C());
        this.worldGen.func_175904_e();
        boolean generated = false;
        int i = count;
        while (i-- > 0) {
            int x = blockX + this.getDensity(dRand, veinDiameter, horizontalDensity);
            int y = blockY + this.getDensity(dRand, veinHeight, verticalDensity);
            int z = blockZ + this.getDensity(dRand, veinDiameter, horizontalDensity);
            if (!this.canGenerateInBiome(world, x, z, random)) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

