/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.integration.appeng.grid.IThEGridHost;
import thaumicenergistics.integration.appeng.grid.ThEGridBlock;
import thaumicenergistics.integration.appeng.util.ThEActionSource;
import thaumicenergistics.item.ItemPartBase;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ItemHandlerUtil;

public abstract class PartBase
implements IPart,
IThEGridHost,
IUpgradeableHost,
IActionHost,
IPowerChannelState {
    protected ThEGridBlock gridBlock;
    protected IGridNode gridNode;
    protected IPartHost host;
    protected TileEntity hostTile;
    protected EntityPlayer owner;
    protected ItemPartBase item;
    public AEPartLocation side;
    public IActionSource source;
    protected boolean isPowered;
    protected boolean isActive;

    public PartBase(ItemPartBase item) {
        this.item = item;
        this.source = new ThEActionSource(this);
    }

    public boolean canWork() {
        return false;
    }

    public double getIdlePowerUsage() {
        return 0.0;
    }

    @Override
    public DimensionalCoord getLocation() {
        if (this.hostTile != null && this.hostTile.func_145830_o() && this.hostTile.func_145831_w().field_73011_w != null) {
            return new DimensionalCoord(this.hostTile.func_145831_w(), this.hostTile.func_174877_v());
        }
        return null;
    }

    public ItemStack getItemStack(PartItemStack type) {
        return new ItemStack((Item)this.item);
    }

    public boolean requireDynamicRender() {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.gridNode != null) {
            this.gridNode.saveToNBT("part", nbt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (this.gridNode != null) {
            this.gridNode.loadFromNBT("part", nbt);
        }
    }

    public int getLightLevel() {
        return 0;
    }

    public boolean isLadder(EntityLivingBase entityLivingBase) {
        return false;
    }

    public void onNeighborChanged(IBlockAccess iBlockAccess, BlockPos blockPos, BlockPos blockPos1) {
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    public void writeToStream(ByteBuf buf) {
        buf.writeBoolean(this.isActive());
        buf.writeBoolean(this.isPowered());
    }

    public boolean readFromStream(ByteBuf buf) {
        this.isActive = buf.readBoolean();
        this.isPowered = buf.readBoolean();
        return true;
    }

    public IGridNode getGridNode() {
        return this.gridNode;
    }

    public void onEntityCollision(Entity entity) {
    }

    public void removeFromWorld() {
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void addToWorld() {
        if (ForgeUtil.isClient()) {
            return;
        }
        this.gridBlock = new ThEGridBlock(this);
        this.gridNode = AEApi.instance().grid().createGridNode((IGridBlock)this.gridBlock);
        if (this.owner != null) {
            this.gridNode.setPlayerID(AEApi.instance().registries().players().getID(this.owner));
        }
        this.gridNode.updateState();
        BlockPos pos = this.gridBlock.getLocation().getPos();
        this.onNeighborChanged(null, pos, pos.func_177972_a(this.side.getFacing()));
    }

    public IGridNode getExternalFacingNode() {
        return null;
    }

    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity te) {
        this.side = side;
        this.host = host;
        this.hostTile = te;
    }

    public boolean onActivate(EntityPlayer entityPlayer, EnumHand enumHand, Vec3d vec3d) {
        return false;
    }

    public boolean onShiftActivate(EntityPlayer entityPlayer, EnumHand enumHand, Vec3d vec3d) {
        return false;
    }

    public void getDrops(List<ItemStack> list, boolean b) {
        ItemHandlerUtil.getInventoryAsList(this.getInventoryByName("upgrades"), list);
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 3.0f;
    }

    public void randomDisplayTick(World world, BlockPos blockPos, Random random) {
    }

    public void onPlacement(EntityPlayer player, EnumHand hand, ItemStack stack, AEPartLocation side) {
        this.owner = player;
    }

    public boolean canBePlacedOn(BusSupport busSupport) {
        return busSupport == BusSupport.CABLE;
    }

    public void getBoxes(IPartCollisionHelper box) {
        box.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        box.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation dir) {
        return this.gridNode;
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation dir) {
        return AECableType.GLASS;
    }

    public void securityBreak() {
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.gridNode != null ? this.gridNode.isActive() : this.isActive;
    }

    @Nonnull
    public IGridNode getActionableNode() {
        return this.gridNode;
    }

    @MENetworkEventSubscribe
    public void updatePowerStatus(MENetworkPowerStatusChange event) {
        try {
            this.isPowered = GridUtil.getEnergyGrid(this).isNetworkPowered();
        }
        catch (GridAccessException e) {
            this.isPowered = false;
        }
    }

    @Override
    public void gridChanged() {
    }

    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    public TileEntity getTile() {
        return this.hostTile;
    }

    public IItemHandler getInventoryByName(String name) {
        return null;
    }
}

