/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.container.ActionType;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.container.DummyContainer;
import thaumicenergistics.container.ICraftingContainer;
import thaumicenergistics.container.crafting.ContainerCraftAmountBridge;
import thaumicenergistics.container.slot.SlotArcaneMatrix;
import thaumicenergistics.container.slot.SlotArcaneResult;
import thaumicenergistics.container.slot.SlotUpgrade;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.util.ThEConfigManager;
import thaumicenergistics.integration.thaumcraft.TCCraftingManager;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketInvHeldUpdate;
import thaumicenergistics.network.packets.PacketMEItemUpdate;
import thaumicenergistics.network.packets.PacketSettingChange;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.network.packets.PacketVisUpdate;
import thaumicenergistics.part.PartArcaneTerminal;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ItemHandlerUtil;
import thaumicenergistics.util.TCUtil;
import thaumicenergistics.util.ThELog;
import thaumicenergistics.util.inventory.ThEInternalInventory;

public class ContainerArcaneTerminal
extends ContainerBase
implements IMEMonitorHandlerReceiver<IAEItemStack>,
ICraftingContainer,
IConfigurableObject {
    public IRecipe recipe;
    private PartArcaneTerminal part;
    private IItemStorageChannel channel;
    private IMEMonitor<IAEItemStack> monitor;
    private IInventory craftingResult;
    private IConfigManager serverConfigManager;
    private IConfigManager clientConfigManager;
    private SlotArcaneResult resultSlot;

    public ContainerArcaneTerminal(EntityPlayer player, PartArcaneTerminal part) {
        super(player);
        this.part = part;
        this.clientConfigManager = new ThEConfigManager();
        this.clientConfigManager.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientConfigManager.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.clientConfigManager.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        if (ForgeUtil.isServer()) {
            this.channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            this.monitor = this.part.getInventory(this.channel);
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            }
            this.serverConfigManager = part.getConfigManager();
        }
        this.addMatrixSlots(32, 36);
        this.addUpgradeSlots(177, 54);
        this.bindPlayerInventory((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), 0, 106);
        this.bindPlayerArmour(player, (IItemHandler)new PlayerArmorInvWrapper(player.field_71071_by), 8, 19);
    }

    @Override
    public void onAction(EntityPlayerMP player, PacketUIAction packet) {
        if (this.monitor == null) {
            return;
        }
        if (packet.action == ActionType.PICKUP_OR_SETDOWN) {
            if (player.field_71071_by.func_70445_o().func_190926_b() && packet.requestedStack != null) {
                IAEItemStack stack = (IAEItemStack)packet.requestedStack.copy();
                stack.setStackSize((long)stack.getDefinition().func_77976_d());
                stack = AEUtil.inventoryExtract(stack, this.monitor, this.part.source);
                if (stack != null) {
                    player.field_71071_by.func_70437_b(stack.createItemStack());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(player.field_71071_by.func_70445_o()));
            } else if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                IAEItemStack stack = (IAEItemStack)this.channel.createStack((Object)player.field_71071_by.func_70445_o());
                if ((stack = AEUtil.inventoryInsert(stack, this.monitor, this.part.source)) != null) {
                    player.field_71071_by.func_70437_b(stack.createItemStack());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(player.field_71071_by.func_70445_o()));
            }
        } else if (packet.action == ActionType.SPLIT_OR_PLACE_SINGLE) {
            if (player.field_71071_by.func_70445_o().func_190926_b() && packet.requestedStack != null) {
                IAEItemStack stack = (IAEItemStack)packet.requestedStack.copy();
                stack.setStackSize((long)stack.getDefinition().func_77976_d());
                stack = AEUtil.inventoryExtract(stack, this.monitor, this.part.source, Actionable.SIMULATE);
                if (stack != null) {
                    long toPull = (long)Math.ceil((double)stack.getStackSize() / 2.0);
                    stack = AEUtil.inventoryExtract(stack.setStackSize(toPull), this.monitor, this.part.source);
                }
                if (stack != null) {
                    player.field_71071_by.func_70437_b(stack.createItemStack());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(player.field_71071_by.func_70445_o()));
            } else if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                IAEItemStack stack = (IAEItemStack)this.channel.createStack((Object)player.field_71071_by.func_70445_o());
                Objects.requireNonNull(stack).setStackSize(1L);
                stack = AEUtil.inventoryInsert(stack, this.monitor, this.part.source);
                if (stack == null) {
                    ItemStack stack2 = player.field_71071_by.func_70445_o();
                    stack2.func_190920_e(stack2.func_190916_E() - 1);
                    if (stack2.func_190926_b()) {
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                    PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(player.field_71071_by.func_70445_o()));
                }
            }
        } else if ((packet.action == ActionType.SCROLL_UP || packet.action == ActionType.PICKUP_SINGLE) && packet.requestedStack instanceof IAEItemStack) {
            ItemStack held = player.field_71071_by.func_70445_o();
            if (!(held.func_190926_b() || held.func_190916_E() < held.func_77976_d() && ForgeUtil.areItemStacksEqual(((IAEItemStack)packet.requestedStack).getDefinition(), held))) {
                return;
            }
            IAEItemStack stack = (IAEItemStack)packet.requestedStack.copy();
            stack.setStackSize(1L);
            stack = AEUtil.inventoryExtract(stack, this.monitor, this.part.source);
            if (stack != null) {
                if (!held.func_190926_b()) {
                    held.func_190917_f(1);
                } else {
                    held = stack.createItemStack();
                }
            }
            player.field_71071_by.func_70437_b(held);
            PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(player.field_71071_by.func_70445_o()));
        } else if (packet.action == ActionType.SCROLL_DOWN && !player.field_71071_by.func_70445_o().func_190926_b()) {
            ItemStack held = player.field_71071_by.func_70445_o();
            IAEItemStack is = (IAEItemStack)this.channel.createStack((Object)held);
            Objects.requireNonNull(is);
            is.setStackSize(1L);
            is = AEUtil.inventoryInsert(is, this.monitor, this.part.source, Actionable.MODULATE);
            if (is != null) {
                return;
            }
            if (held.func_190916_E() > 1) {
                held.func_190918_g(1);
            } else {
                held = ItemStack.field_190927_a;
            }
            player.field_71071_by.func_70437_b(held);
            PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(player.field_71071_by.func_70445_o()));
        } else if (packet.action == ActionType.SHIFT_MOVE && packet.requestedStack instanceof IAEItemStack) {
            IAEItemStack stack = ((IAEItemStack)packet.requestedStack).copy();
            ItemStack is = stack.createItemStack();
            stack.setStackSize((long)is.func_77976_d());
            is.func_190920_e((int)stack.getStackSize());
            is = ForgeUtil.addStackToPlayerInventory((EntityPlayer)player, is, true);
            if (!is.func_190926_b()) {
                stack.setStackSize(stack.getStackSize() - (long)is.func_190916_E());
            }
            if ((stack = AEUtil.inventoryExtract(stack, this.monitor, this.part.source)) != null) {
                ForgeUtil.addStackToPlayerInventory((EntityPlayer)player, stack.createItemStack(), false);
            }
        } else if (packet.action == ActionType.AUTO_CRAFT) {
            if (!packet.requestedStack.isCraftable()) {
                return;
            }
            GuiHandler.openGUI(ModGUIs.AE2_CRAFT_AMOUNT, (EntityPlayer)player, this.part.getLocation().getPos(), this.part.side);
            if (player.field_71070_bA instanceof ContainerCraftAmountBridge) {
                ContainerCraftAmountBridge cca = (ContainerCraftAmountBridge)player.field_71070_bA;
                cca.getCraftingItem().func_75215_d(packet.requestedStack.asItemStackRepresentation());
                cca.setItemToCraft((IAEItemStack)packet.requestedStack);
            }
        } else if (packet.action == ActionType.CLEAR_GRID) {
            AEUtil.clearIntoMEInventory(this.getInventory("crafting"), this.monitor, this.part.source);
        }
        this.onMatrixChanged();
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        if (ForgeUtil.isClient() || index < 0 || index > this.field_75151_b.size()) {
            return super.func_82846_b(playerIn, index);
        }
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot.func_75216_d() && !slot.func_75211_c().func_190926_b()) {
            IAEItemStack remaining = AEUtil.inventoryInsert(this.channel.createStack((Object)slot.func_75211_c()), this.monitor, this.part.source, Actionable.MODULATE);
            slot.func_75215_d(remaining == null ? ItemStack.field_190927_a : remaining.createItemStack());
            this.func_75142_b();
        }
        return super.func_82846_b(playerIn, index);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.player instanceof IContainerListener) {
            this.sendVisInfo((IContainerListener)this.player);
        }
        if (ForgeUtil.isServer()) {
            for (Settings setting : this.serverConfigManager.getSettings()) {
                Enum server = this.serverConfigManager.getSetting(setting);
                Enum client = this.clientConfigManager.getSetting(setting);
                if (client == server) continue;
                for (IContainerListener player : this.field_75149_d) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    this.clientConfigManager.putSetting(setting, server);
                    PacketHandler.sendToPlayer((EntityPlayerMP)player, new PacketSettingChange(setting, server));
                }
            }
        }
    }

    @Override
    public void handleJEITransfer(EntityPlayer player, NBTTagCompound tag) {
        NBTTagList normal = tag.func_150295_c("normal", 9);
        NBTTagList crystals = tag.func_150295_c("crystal", 9);
        List<NBTBase> ingredients = ForgeUtil.toArrayList(ForgeUtil.mergeTagLists(normal, crystals));
        AtomicInteger currentSlot = new AtomicInteger(-1);
        IItemHandler crafting = this.getInventory("crafting");
        IItemHandler playerInv = this.getInventory("player");
        boolean clearSuccess = AEUtil.clearIntoMEInventory(crafting, this.monitor, this.part.source);
        this.onMatrixChanged();
        if (!clearSuccess) {
            return;
        }
        ingredients.forEach(ingredientGroup -> {
            int slot = currentSlot.incrementAndGet();
            if (ingredientGroup == null || ingredientGroup.func_82582_d()) {
                return;
            }
            NBTTagList subs = (NBTTagList)ingredientGroup;
            for (int i = 0; i < subs.func_74745_c(); ++i) {
                NBTTagCompound ingredient = subs.func_150305_b(i);
                ItemStack stack = new ItemStack(ingredient);
                if (stack.func_190926_b()) {
                    ThELog.error("Failed to read ingredient data {}", ingredient);
                    return;
                }
                ThELog.debug("Adding {} for {}", stack.func_82833_r(), slot);
                IAEItemStack aeStack = (IAEItemStack)this.channel.createStack((Object)stack);
                if (aeStack == null) {
                    ThELog.warn("Failed to create IAEItemStack for {}, report to developer!", stack.toString());
                    return;
                }
                IAEItemStack aeExtract = AEUtil.inventoryExtract(aeStack, this.monitor, this.part.source);
                if (aeExtract != null && aeExtract.getStackSize() > 0L) {
                    crafting.insertItem(slot, aeExtract.createItemStack(), false);
                }
                if (crafting.getStackInSlot(slot).func_190916_E() >= stack.func_190916_E()) {
                    return;
                }
                ThELog.debug("Failed to pull item from ae inv, trying player inventory", new Object[0]);
                stack.func_190918_g(crafting.getStackInSlot(slot).func_190916_E());
                ItemStack invExtract = ItemHandlerUtil.extract(playerInv, stack, false);
                if (invExtract.func_190926_b()) continue;
                crafting.insertItem(slot, invExtract, false);
            }
            ThELog.debug("Failed to find valid item", new Object[0]);
        });
        this.onMatrixChanged();
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource actionSource) {
        for (IContainerListener c : this.field_75149_d) {
            this.sendInventory(c);
        }
    }

    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.sendInventory(c);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.sendVisInfo(listener);
        this.sendInventory(listener);
        this.onMatrixChanged();
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    @Override
    public void onMatrixChanged() {
        if (ForgeUtil.isClient()) {
            return;
        }
        this.craftingResult.func_70299_a(0, ItemStack.field_190927_a);
        this.func_75142_b();
        IItemHandler matrix = this.getInventory("crafting");
        this.recipe = TCCraftingManager.findArcaneRecipe(matrix, this.player);
        if (this.recipe != null) {
            this.craftingResult.func_70299_a(0, TCCraftingManager.getCraftingResult(this.getInventory("crafting"), (IArcaneRecipe)this.recipe));
            this.func_75142_b();
            return;
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, matrix.getStackInSlot(i));
        }
        this.recipe = CraftingManager.func_192413_b((InventoryCrafting)inventory, (World)this.player.field_70170_p);
        if (this.recipe != null) {
            this.craftingResult.func_70299_a(0, this.recipe.func_77572_b(inventory));
            this.func_75142_b();
        }
    }

    @Override
    public int tryCraft(int amount) {
        this.onMatrixChanged();
        if (this.recipe == null || ForgeUtil.isClient()) {
            return 0;
        }
        float canCraft = amount;
        if (this.recipe instanceof IArcaneRecipe) {
            float visRequired = (float)((IArcaneRecipe)this.recipe).getVis() * (1.0f - this.getDiscount(this.player));
            canCraft = this.getWorldVis() / visRequired;
        }
        return Math.min(amount, (int)canCraft);
    }

    @Override
    public ItemStack onCraft(ItemStack toCraft) {
        IItemHandler crafting = this.getInventory("crafting");
        InventoryCrafting inv = this.getInvCrafting(crafting, this.recipe);
        ItemStack crafted = this.recipe.func_77572_b(inv);
        int roomLeft = Math.min(crafted.func_77976_d(), toCraft.func_190916_E() * crafted.func_190916_E());
        int timesCrafted = 0;
        boolean craftAgain = true;
        do {
            roomLeft -= crafted.func_190916_E();
            NonNullList<ItemStack> remaining = this.getRemaining(this.recipe, inv);
            for (int j = 0; j < remaining.size(); ++j) {
                if (crafting.getStackInSlot(j).func_190926_b()) continue;
                ItemStack extract = crafting.extractItem(j, Integer.MAX_VALUE, false);
                if (!((ItemStack)remaining.get(j)).func_190926_b()) {
                    crafting.insertItem(j, (ItemStack)remaining.get(j), false);
                    continue;
                }
                crafting.insertItem(j, this.getRefill(extract), false);
            }
            if (this.getRequiredVis(this.recipe, this.player) > 0.0f) {
                TCUtil.drainVis(this.part.getTile().func_145831_w(), this.part.getTile().func_174877_v(), this.getRequiredVis(this.recipe, this.player), this.getInventory("upgrades").getStackInSlot(0).func_190926_b() ? 0 : 1);
            }
            if (!this.recipe.func_77569_a(inv = this.getInvCrafting(crafting, this.recipe), this.player.field_70170_p)) {
                craftAgain = false;
            }
            if (this.getWorldVis() < this.getRequiredVis(this.recipe, this.player)) {
                craftAgain = false;
            }
            ++timesCrafted;
        } while (roomLeft > 0 && roomLeft >= crafted.func_190916_E() && craftAgain);
        crafted.func_190920_e(timesCrafted * crafted.func_190916_E());
        this.onMatrixChanged();
        this.func_75142_b();
        if (crafted.func_190916_E() > 0) {
            crafted.func_77980_a(this.player.field_70170_p, this.player, crafted.func_190916_E());
            FMLCommonHandler.instance().firePlayerCraftingEvent(this.player, crafted, (IInventory)inv);
            if (this.recipe != null && !this.recipe.func_192399_d()) {
                this.player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{this.recipe}));
            }
        }
        return crafted;
    }

    @Override
    public IItemHandler getInventory(String name) {
        switch (name.toLowerCase()) {
            case "crafting": 
            case "upgrades": {
                return this.part.getInventoryByName(name);
            }
            case "result": {
                return new InvWrapper(this.craftingResult);
            }
            case "player": {
                return new PlayerInvWrapper(this.player.field_71071_by);
            }
        }
        return null;
    }

    public IConfigManager getConfigManager() {
        return ForgeUtil.isClient() ? this.clientConfigManager : this.serverConfigManager;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public BlockPos getPartPos() {
        return this.part.getLocation().getPos();
    }

    public AEPartLocation getPartSide() {
        return this.part.side;
    }

    private void addMatrixSlots(int offsetX, int offsetY) {
        int j;
        int i;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotArcaneMatrix(this, i * 3 + j, offsetX + j * 18, offsetY + i * 18));
            }
        }
        offsetX += 104;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                this.func_75146_a(new SlotArcaneMatrix(this, 9 + (i * 2 + j), offsetX + j * 18, offsetY + i * 18));
            }
        }
        this.craftingResult = new ThEInternalInventory("Result", 1, 64);
        this.resultSlot = new SlotArcaneResult(this, this.player, 0, (offsetX -= 104) + 84, offsetY + 18);
        this.func_75146_a(this.resultSlot);
        this.onMatrixChanged();
    }

    private void addUpgradeSlots(int offsetX, int offsetY) {
        this.func_75146_a(new SlotUpgrade(this.getInventory("upgrades"), 0, offsetX, offsetY));
    }

    protected void sendVisInfo(IContainerListener listener) {
        if (ForgeUtil.isClient() || !(listener instanceof EntityPlayerMP)) {
            return;
        }
        PacketHandler.sendToPlayer((EntityPlayerMP)this.player, new PacketVisUpdate(this.getWorldVis(), this.getRequiredVis(this.recipe, this.player), this.getDiscount(this.player)));
    }

    protected float getWorldVis() {
        TileEntity te = this.part.getTile();
        float vis = AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v());
        if (!this.getInventory("upgrades").getStackInSlot(0).func_190926_b()) {
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(-16, 0, -16));
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(-16, 0, 0));
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(-16, 0, 16));
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(0, 0, -16));
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(0, 0, 16));
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(16, 0, -16));
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(16, 0, 0));
            vis += AuraHelper.getVis((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177982_a(16, 0, 16));
        }
        return vis;
    }

    protected float getRequiredVis(IRecipe recipe, EntityPlayer player) {
        if (!(recipe instanceof IArcaneRecipe)) {
            return -1.0f;
        }
        return (float)((IArcaneRecipe)recipe).getVis() * (1.0f - this.getDiscount(player));
    }

    protected float getDiscount(EntityPlayer player) {
        return TCCraftingManager.getDiscount(player);
    }

    private NonNullList<ItemStack> getRemaining(IRecipe recipe, InventoryCrafting inv) {
        NonNullList remaining = recipe.func_179532_b(inv);
        AspectList crystals = this.recipe instanceof IArcaneRecipe ? ((IArcaneRecipe)this.recipe).getCrystals() : null;
        for (int i = 0; i < remaining.size(); ++i) {
            if (i < 9) {
                boolean hasLeftover = !((ItemStack)remaining.get(i)).func_190926_b();
                ItemStack existing = inv.func_70301_a(i);
                if (existing.func_190916_E() <= 1) continue;
                if (!hasLeftover) {
                    existing.func_190918_g(1);
                }
                remaining.set(i, (Object)existing);
                continue;
            }
            if (crystals == null || crystals.size() < 1) break;
            ItemStack crystalStack = inv.func_70301_a(i);
            if (crystalStack.func_190926_b()) continue;
            Aspect crystalAspect = TCUtil.getCrystalAspect(crystalStack);
            if (crystals.getAmount(crystalAspect) > 0) {
                crystalStack.func_190918_g(crystals.getAmount(crystalAspect));
            }
            if (crystalStack.func_190916_E() <= 0) continue;
            remaining.set(i, (Object)crystalStack);
        }
        return remaining;
    }

    private ItemStack getRefill(ItemStack stack) {
        IAEItemStack aeStack = (IAEItemStack)this.monitor.extractItems(this.channel.createStack((Object)stack), Actionable.SIMULATE, this.part.source);
        if (aeStack != null && aeStack.getStackSize() == (long)stack.func_190916_E()) {
            return ((IAEItemStack)this.monitor.extractItems((IAEStack)aeStack, Actionable.MODULATE, this.part.source)).createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    private void sendInventory(IContainerListener listener) {
        if (ForgeUtil.isClient() || !(listener instanceof EntityPlayerMP) || this.monitor == null) {
            return;
        }
        IItemList storage = this.monitor.getStorageList();
        PacketMEItemUpdate packet = new PacketMEItemUpdate();
        for (IAEItemStack stack : storage) {
            packet.appendStack(stack);
        }
        PacketHandler.sendToPlayer((EntityPlayerMP)listener, packet);
    }

    private InventoryCrafting getInvCrafting(IItemHandler handler, IRecipe recipe) {
        if (recipe instanceof IArcaneRecipe) {
            return TCCraftingManager.getInvFromItemHandler(handler);
        }
        InventoryCrafting inv = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, this.getInventory("crafting").getStackInSlot(i).func_77946_l());
        }
        return inv;
    }

    private boolean isCrystalRequired(IRecipe recipe, ItemStack stack) {
        if (!(recipe instanceof IArcaneRecipe) || stack.func_190926_b() || !(stack.func_77973_b() instanceof IEssentiaContainerItem) || stack.func_77973_b() != ItemsTC.crystalEssence) {
            return false;
        }
        AspectList aspect = ((IEssentiaContainerItem)stack.func_77973_b()).getAspects(stack);
        return ((IArcaneRecipe)recipe).getCrystals().getAmount(aspect.getAspects()[0]) > 0;
    }
}

