/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.part;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.widgets.GuiImgButton;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.client.gui.helpers.GuiScrollBar;
import thaumicenergistics.client.gui.helpers.MERepo;
import thaumicenergistics.client.gui.part.GuiAbstractTerminal;
import thaumicenergistics.config.ThEConfig;
import thaumicenergistics.container.ActionType;
import thaumicenergistics.container.part.ContainerEssentiaTerminal;
import thaumicenergistics.container.slot.SlotME;
import thaumicenergistics.container.slot.ThESlot;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketSettingChange;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.util.ThEUtil;

public class GuiEssentiaTerminal
extends GuiAbstractTerminal<IAEEssentiaStack, IEssentiaStorageChannel> {
    private GuiScrollBar scrollBar;
    private GuiImgButton sortByButton;
    private GuiImgButton sortDirButton;
    private GuiImgButton terminalSizeButton;
    private int rows = 6;

    public GuiEssentiaTerminal(ContainerEssentiaTerminal container) {
        super(container);
        this.repo = new MERepo(IEssentiaStorageChannel.class);
    }

    public void func_73866_w_() {
        this.field_146999_f = 197;
        this.field_147000_g = 114;
        double remainingY = this.field_146295_m - this.field_147000_g;
        int maxRows = (int)Math.floor(remainingY / 18.0);
        this.rows = ThEApi.instance().config().terminalStyle() != TerminalStyle.TALL ? Math.min(maxRows, 6) : maxRows;
        this.field_147000_g += 18 * this.rows;
        this.scrollBar = new GuiScrollBar(175, 18, 18 * this.rows - 2);
        this.repo.setScrollBar(this.scrollBar);
        this.updateScroll();
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotME);
        this.addTerminalSlots(9, 18);
        this.field_146292_n.clear();
        super.func_73866_w_();
        IConfigManager cm = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        this.sortByButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 8, (Enum)Settings.SORT_BY, cm.getSetting(Settings.SORT_BY));
        this.sortDirButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 28, (Enum)Settings.SORT_DIRECTION, cm.getSetting(Settings.SORT_DIRECTION));
        this.terminalSizeButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 48, (Enum)Settings.TERMINAL_STYLE, (Enum)ThEApi.instance().config().terminalStyle());
        this.func_189646_b((GuiButton)this.sortByButton);
        this.func_189646_b((GuiButton)this.sortDirButton);
        this.func_189646_b((GuiButton)this.terminalSizeButton);
        this.field_147002_h.field_75151_b.forEach(slot -> {
            if (slot instanceof ThESlot) {
                ((ThESlot)((Object)slot)).recalculateY(this.rows);
            }
        });
    }

    @Override
    public void reload() {
        this.func_73866_w_();
    }

    private void addTerminalSlots(int offsetX, int offsetY) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.addMESlot(new SlotME(this.repo, c + r * 9, offsetX + c * 18, offsetY + r * 18));
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(this.getGuiBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.getXSize(), 18);
        this.func_73729_b(this.field_147003_i + 100, this.field_147009_r, 5, 0, 70, 16);
        this.func_73729_b(this.field_147003_i + 50, this.field_147009_r, 5, 0, 70, 16);
        for (int i = 0; i < this.rows; ++i) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + 18 + i * 18, 0, 18, this.getXSize(), 18);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r + 16 + this.rows * 18, 0, 70, this.getXSize(), 176);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(ThEApi.instance().lang().guiEssentiaTerminal().getLocalizedKey(new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.getYSize() - 93, 0x404040);
        if (this.scrollBar != null) {
            this.scrollBar.draw(this);
        }
    }

    @Override
    public void updateSetting(Settings setting, Enum value) {
        super.updateSetting(setting, value);
        this.repo.setSortOrder((SortOrder)((IConfigurableObject)this.field_147002_h).getConfigManager().getSetting(Settings.SORT_BY));
        this.repo.setSortDir((SortDir)((IConfigurableObject)this.field_147002_h).getConfigManager().getSetting(Settings.SORT_DIRECTION));
        this.repo.updateView();
        this.updateScroll();
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.scrollBar != null) {
            boolean flag;
            int x = mouseX - this.getGuiLeft();
            int y = mouseY - this.getGuiTop();
            boolean bl = flag = x >= this.scrollBar.getX() && x <= this.scrollBar.getX() + 15 && y >= this.scrollBar.getY() && y <= this.scrollBar.getY() + this.scrollBar.getHeight();
            if (flag) {
                this.scrollBar.click(y);
            }
            this.repo.updateView();
            this.updateScroll();
        }
        if (button == 1) {
            for (GuiButton btn : this.field_146292_n) {
                if (!btn.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                super.func_73864_a(mouseX, mouseY, 0);
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.scrollBar != null) {
            boolean flag;
            int x = mouseX - this.getGuiLeft();
            int y = mouseY - this.getGuiTop();
            boolean bl = flag = x >= this.scrollBar.getX() && x <= this.scrollBar.getX() + 15 && y >= this.scrollBar.getY() && y <= this.scrollBar.getY() + this.scrollBar.getHeight();
            if (flag) {
                this.scrollBar.click(y);
                this.repo.updateView();
                this.updateScroll();
            }
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot instanceof SlotME) {
            if (slot.func_75216_d()) {
                PacketHandler.sendToServer(new PacketUIAction(ActionType.FILL_ESSENTIA_ITEM, (IAEStack)((SlotME)slot).getAEStack()));
            } else {
                PacketHandler.sendToServer(new PacketUIAction(ActionType.EMPTY_ESSENTIA_ITEM));
            }
            return;
        }
        super.func_184098_a(slot, slotId, mouseButton, type);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta != 0 && this.scrollBar != null) {
            this.scrollBar.wheel(delta);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiImgButton) {
            GuiImgButton btn = (GuiImgButton)button;
            Enum currentValue = btn.getCurrentValue();
            Enum next = ThEUtil.rotateEnum(currentValue, btn.getSetting().getPossibleValues(), Mouse.isButtonDown((int)1));
            if (next.equals(SortOrder.MOD)) {
                next = ThEUtil.rotateEnum(next, btn.getSetting().getPossibleValues(), Mouse.isButtonDown((int)1));
            }
            btn.set(next);
            if (btn.getSetting() == Settings.TERMINAL_STYLE) {
                ThEConfig.client.terminalStyle = (TerminalStyle)next;
                ThEConfig.save();
                this.reload();
                return;
            }
            PacketHandler.sendToServer(new PacketSettingChange(btn.getSetting(), next));
        }
    }

    public void onMEStorageUpdate(IItemList<IAEEssentiaStack> list) {
        this.repo.clear();
        for (IAEEssentiaStack stack : list) {
            this.repo.postUpdate(stack);
        }
        this.repo.updateView();
        this.updateScroll();
    }

    public void updateScroll() {
        this.scrollBar.setRows(this.rows);
        this.scrollBar.setRange(0, (this.repo.size() + 8) / 9 - this.rows, Math.max(1, this.rows / 6));
    }

    @Override
    protected ResourceLocation getGuiBackground() {
        return new ResourceLocation("appliedenergistics2", "textures/guis/terminal.png");
    }
}

