/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.api;

import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.api.aspects.Aspect;

public class EssentiaStack {
    private String aspect;
    private int amount;

    public EssentiaStack(Aspect aspect, int amount) {
        this(aspect != null ? aspect.getTag() : "", amount);
    }

    public EssentiaStack(String aspect, int amount) {
        if (aspect == null || aspect.isEmpty()) {
            throw new IllegalArgumentException("Aspect cannot be null");
        }
        this.aspect = aspect;
        this.amount = amount;
    }

    private EssentiaStack(EssentiaStack old) {
        this.aspect = old.getAspectTag();
        this.amount = old.getAmount();
    }

    private EssentiaStack() {
    }

    public String getAspectTag() {
        return this.aspect;
    }

    public Aspect getAspect() {
        return Aspect.getAspect((String)this.getAspectTag());
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74778_a("Aspect", this.getAspectTag());
        tag.func_74768_a("Amount", this.getAmount());
        return tag;
    }

    public void read(NBTTagCompound tag) {
        this.aspect = tag.func_74779_i("Aspect");
        this.amount = tag.func_74762_e("Amount");
    }

    public EssentiaStack copy() {
        return new EssentiaStack(this);
    }

    public static EssentiaStack readFromNBT(NBTTagCompound tag) {
        if (tag != null && !tag.func_82582_d()) {
            EssentiaStack stack = new EssentiaStack();
            stack.read(tag);
            return stack.getAspect() != null && stack.getAmount() > 0 ? stack : null;
        }
        return null;
    }
}

