/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier0;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class TileIronFurnace
extends RebornMachineTile
implements IInventoryProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileIronFurnace", 64, (TileEntity)this);
    public int fuel;
    public int fuelGague;
    public int progress;
    public int fuelScale = 160;
    int input1 = 0;
    int output = 1;
    int fuelslot = 2;
    boolean active = false;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = this.fuelScale;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel > 0) {
            --this.fuel;
            this.updateState();
        }
        if (this.fuel <= 0 && this.canSmelt()) {
            this.fuel = this.fuelGague = (int)((double)TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(this.fuelslot)) * 1.25);
            if (this.fuel > 0) {
                ItemStack fuelStack = this.func_70301_a(this.fuelslot);
                if (fuelStack.func_77973_b().hasContainerItem(fuelStack)) {
                    this.func_70299_a(this.fuelslot, new ItemStack(fuelStack.func_77973_b().func_77668_q()));
                } else if (fuelStack.func_190916_E() > 1) {
                    this.func_70298_a(this.fuelslot, 1);
                } else if (fuelStack.func_190916_E() == 1) {
                    this.func_70299_a(this.fuelslot, ItemStack.field_190927_a);
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
            if (this.func_70301_a(this.output).func_190926_b()) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
                this.func_70301_a(this.output).func_190917_f(itemstack.func_190916_E());
            }
            if (this.func_70301_a(this.input1).func_190916_E() > 1) {
                this.func_70298_a(this.input1, 1);
            } else {
                this.func_70299_a(this.input1, ItemStack.field_190927_a);
            }
        }
    }

    public boolean canSmelt() {
        if (this.func_70301_a(this.input1).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (this.func_70301_a(this.output).func_190926_b()) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a(this.output).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        if (!result.func_190926_b()) {
            return result.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public void updateState() {
        this.setActive(this.fuel > 0);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        ItemStack fuelSlotStack;
        boolean isFuel = TileEntityFurnace.func_145954_b((ItemStack)stack);
        if (isFuel && ((fuelSlotStack = this.func_70301_a(this.fuelslot)).func_190926_b() || ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)fuelSlotStack, (boolean)true, (boolean)true) && fuelSlotStack.func_77976_d() != fuelSlotStack.func_190916_E())) {
            return index == this.fuelslot;
        }
        return index != this.output;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public int getBurnTime() {
        return this.fuel;
    }

    public void setBurnTime(int burnTime) {
        this.fuel = burnTime;
    }

    public int getTotalBurnTime() {
        return this.fuelGague;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.fuelGague = totalBurnTime;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("ironfurnace").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).fuelSlot(2, 56, 53).slot(0, 56, 17).outputSlot(1, 116, 35).syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getProgress, this::setProgress).syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create((RebornMachineTile)this);
    }
}

