/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.storage;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.blocks.storage.BlockEnergyStorage;
import techreborn.tiles.IRedstoneHandler;

public abstract class TileEnergyStorage
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IRedstoneHandler {
    public Inventory inventory;
    public String name;
    public Block wrenchDrop;
    public EnumPowerTier tier;
    public int maxInput;
    public int maxOutput;
    public int maxStorage;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)5;
    public int redstoneSignal = 0;

    public TileEnergyStorage(String name, int invSize, Block wrenchDrop, EnumPowerTier tier, int maxInput, int maxOuput, int maxStorage) {
        this.inventory = new Inventory(invSize, "Tile" + name, 64, (TileEntity)this);
        this.wrenchDrop = wrenchDrop;
        this.tier = tier;
        this.name = name;
        this.maxInput = maxInput;
        this.maxOutput = maxOuput;
        this.maxStorage = maxStorage;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.redstoneSignal = tag.func_74762_e("redstoneSignal");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("redstoneSignal", this.redstoneSignal);
        return tag;
    }

    public void func_73660_a() {
        int newRedstoneSignal;
        ItemStack stack;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.inventory.func_70301_a(0).func_190926_b() && ExternalPowerSystems.isPoweredItem((ItemStack)(stack = this.inventory.func_70301_a(0)))) {
            ExternalPowerSystems.chargeItem((TilePowerAcceptor)this, (ItemStack)stack);
        }
        if (!this.inventory.func_70301_a(1).func_190926_b()) {
            this.charge(1);
        }
        int n = newRedstoneSignal = this.shouldEmitRedstoneSignal() ? 15 : 0;
        if (this.redstoneSignal != newRedstoneSignal) {
            this.redstoneSignal = newRedstoneSignal;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, false);
        }
    }

    public double getBaseMaxPower() {
        return this.maxStorage;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return this.getFacing() != direction;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return this.getFacing() == direction;
    }

    public double getBaseMaxOutput() {
        return this.maxOutput;
    }

    public double getBaseMaxInput() {
        return this.maxInput;
    }

    public EnumPowerTier getBaseTier() {
        return this.tier;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public EnumFacing getFacing() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockEnergyStorage) {
            return ((BlockEnergyStorage)block).getFacing(this.field_145850_b, this.field_174879_c);
        }
        return null;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.wrenchDrop);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public int getRedstoneLevel() {
        return this.redstoneSignal;
    }

    @Override
    public int getComparatorValue() {
        return Math.min((int)(this.getEnergy() * 15.0 / this.getBaseMaxPower()), 15);
    }

    protected boolean shouldEmitRedstoneSignal() {
        switch (this.redstoneMode) {
            case 1: {
                return this.getEnergy() >= this.getBaseMaxPower() - (double)(this.maxOutput * 20);
            }
            case 2: {
                return this.getEnergy() > (double)this.maxOutput && this.getEnergy() < this.getBaseMaxPower() - (double)this.maxOutput;
            }
            case 3: {
                return this.getEnergy() < this.getBaseMaxPower() - (double)this.maxOutput;
            }
            case 4: {
                return this.getEnergy() < (double)this.maxOutput;
            }
        }
        return false;
    }

    public boolean canSetFacing(EnumFacing facing) {
        return true;
    }

    public boolean setFacing(EnumFacing facing) {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEnergyStorage.FACING, (Comparable)facing));
        return true;
    }

    public int getRedstoneModeInt() {
        return this.redstoneMode & 0xFF;
    }

    public void setRedstoneModeInt(int redstoneModeInt) {
        this.redstoneMode = (byte)redstoneModeInt;
    }
}

