/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.util.ItemUtils;
import techreborn.items.ItemTR;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.reactor.IReactor", modid="ic2"), @Optional.Interface(iface="ic2.api.reactor.IReactorComponent", modid="ic2")})
public abstract class ItemDamageableReactorComponent
extends ItemTR
implements IReactorComponent {
    private final int maxDamage;

    public ItemDamageableReactorComponent(String name, int maxDamage) {
        this.func_77655_b("techreborn." + name);
        this.setNoRepair();
        this.maxDamage = maxDamage;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamage(stack) / (double)this.getMaxDamage(stack);
    }

    public int getDamage(ItemStack stack) {
        NBTTagCompound data = ItemUtils.getStackNbtData((ItemStack)stack);
        return data.func_74764_b("damage") ? data.func_74762_e("damage") : 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxDamage;
    }

    public void setDamage(ItemStack stack, int damage) {
        NBTTagCompound data = ItemUtils.getStackNbtData((ItemStack)stack);
        data.func_74768_a("damage", damage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        tooltip.add(this.getMaxDamage(stack) - this.getDamage(stack) + "/" + this.getMaxDamage(stack));
    }

    @Optional.Method(modid="ic2")
    public abstract void processChamber(ItemStack var1, IReactor var2, int var3, int var4, boolean var5);

    @Optional.Method(modid="ic2")
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Optional.Method(modid="ic2")
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Optional.Method(modid="ic2")
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        return heat;
    }

    @Optional.Method(modid="ic2")
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return 0.0f;
    }

    @Optional.Method(modid="ic2")
    public boolean canBePlacedIn(ItemStack itemStack, IReactor reactor) {
        return true;
    }
}

