/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.rollingMachine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipeWrapper;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RollingMachineRecipeWrapper
implements IRecipeWrapper {
    private final IRecipeWrapper baseRecipe;

    public RollingMachineRecipeWrapper(IRecipeWrapper baseRecipe) {
        this.baseRecipe = baseRecipe;
    }

    @Nullable
    public static RollingMachineRecipeWrapper create(@Nonnull IJeiHelpers jeiHelpers, IRecipe baseRecipe) {
        ShapelessRecipeWrapper recipeWrapper;
        if (baseRecipe instanceof ShapelessRecipes) {
            recipeWrapper = new ShapelessRecipeWrapper(jeiHelpers, baseRecipe);
        } else if (baseRecipe instanceof ShapedRecipes) {
            recipeWrapper = new ShapedRecipesWrapper(jeiHelpers, (ShapedRecipes)baseRecipe);
        } else if (baseRecipe instanceof ShapedOreRecipe) {
            recipeWrapper = new ShapedOreRecipeWrapper(jeiHelpers, (ShapedOreRecipe)baseRecipe);
        } else if (baseRecipe instanceof ShapelessOreRecipe) {
            recipeWrapper = new ShapelessRecipeWrapper(jeiHelpers, baseRecipe);
        } else {
            return null;
        }
        return new RollingMachineRecipeWrapper((IRecipeWrapper)recipeWrapper);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        this.baseRecipe.getIngredients(ingredients);
    }
}

