/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.common.util.ItemUtils;

public abstract class RecipeWrapper
implements IRecipeWrapper {
    protected final Recipe recipe;
    protected final List<List<ItemStack>> itemInputs = new ArrayList<List<ItemStack>>();
    protected final List<List<FluidStack>> fluidInputs = new ArrayList<List<FluidStack>>();
    protected final List<ItemStack> itemOutputs = new ArrayList<ItemStack>();
    protected final List<FluidStack> fluidOutputs = new ArrayList<FluidStack>();

    public RecipeWrapper(Recipe recipe) {
        this.recipe = recipe;
        for (InputIngredient inputIngredient : recipe.getInputIngredients()) {
            if (inputIngredient instanceof ItemStackInputIngredient) {
                this.itemInputs.add(Collections.singletonList((ItemStack)inputIngredient.ingredient));
                continue;
            }
            if (inputIngredient instanceof OreDictionaryInputIngredient) {
                ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
                for (ItemStack stack : OreDictionary.getOres((String)((String)inputIngredient.ingredient))) {
                    temp.add(RecipeWrapper.copyWithSize(stack, inputIngredient.getCount()));
                }
                this.itemInputs.add(temp);
                continue;
            }
            if (!(inputIngredient instanceof FluidStackInputIngredient)) continue;
            this.fluidInputs.add(Collections.singletonList((FluidStack)inputIngredient.ingredient));
        }
        this.itemOutputs.addAll(Arrays.asList(recipe.getItemOutputs()));
        this.fluidOutputs.addAll(Arrays.asList(recipe.getFluidOutputs()));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.itemInputs);
        ingredients.setInputLists(VanillaTypes.FLUID, this.fluidInputs);
        ingredients.setOutputs(VanillaTypes.ITEM, this.itemOutputs);
        ingredients.setOutputs(VanillaTypes.FLUID, this.fluidOutputs);
    }

    public static ItemStack copyWithSize(ItemStack stack, int size) {
        if (ItemUtils.isEmpty((ItemStack)stack)) {
            return ItemStack.field_190927_a;
        }
        return ItemUtils.setSize((ItemStack)stack.func_77946_l(), (int)size);
    }
}

