/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.forgeenergy.ForgeEnergyIntegration;
import mekanism.common.integration.ic2.IC2Integration;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaIntegration;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityElectricBlock
extends TileEntityContainerBlock
implements IEnergyWrapper {
    public double electricityStored;
    public double BASE_MAX_ENERGY;
    public double maxEnergy;
    private boolean ic2Registered = false;
    private CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration> teslaManager = new CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration>(IEnergyWrapper.class, TeslaIntegration.class);
    private CapabilityWrapperManager<IEnergyWrapper, ForgeEnergyIntegration> forgeEnergyManager = new CapabilityWrapperManager<IEnergyWrapper, ForgeEnergyIntegration>(IEnergyWrapper.class, ForgeEnergyIntegration.class);

    public TileEntityElectricBlock(String name, double baseMaxEnergy) {
        super(name);
        this.maxEnergy = this.BASE_MAX_ENERGY = baseMaxEnergy;
    }

    @Optional.Method(modid="ic2")
    public void register() {
        if (!this.field_145850_b.field_72995_K && !this.ic2Registered) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.ic2Registered = true;
        }
    }

    @Optional.Method(modid="ic2")
    public void deregister() {
        if (!this.field_145850_b.field_72995_K && this.ic2Registered) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.ic2Registered = false;
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return true;
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
        MekanismUtils.saveChunk(this);
    }

    @Override
    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.setEnergy(dataStream.readDouble());
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.getEnergy());
        return data;
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Override
    public void func_145829_t() {
        boolean wasInvalid = this.field_145846_f;
        super.func_145829_t();
        if (wasInvalid && MekanismUtils.useIC2()) {
            this.register();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.getEnergy());
        return nbtTags;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return RFIntegration.toRF(this.acceptEnergy(from, RFIntegration.fromRF(maxReceive), simulate));
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return RFIntegration.toRF(this.pullEnergy(from, RFIntegration.fromRF(maxExtract), simulate));
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return this.sideIsConsumer(from) || this.sideIsOutput(from);
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return RFIntegration.toRF(this.getEnergy());
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return RFIntegration.toRF(this.getMaxEnergy());
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return !MekanismConfig.current().general.blacklistIC2.val() ? 4 : 0;
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return !MekanismConfig.current().general.blacklistIC2.val() ? 4 : 0;
    }

    @Optional.Method(modid="ic2")
    public int addEnergy(int amount) {
        if (!MekanismConfig.current().general.blacklistIC2.val()) {
            this.setEnergy(this.getEnergy() + IC2Integration.fromEU(amount));
            return IC2Integration.toEUAsInt(this.getEnergy());
        }
        return 0;
    }

    @Optional.Method(modid="ic2")
    public boolean isTeleporterCompatible(EnumFacing side) {
        return !MekanismConfig.current().general.blacklistIC2.val() && this.sideIsOutput(side);
    }

    @Override
    public boolean canOutputEnergy(EnumFacing side) {
        return this.sideIsOutput(side);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return !MekanismConfig.current().general.blacklistIC2.val() && this.sideIsConsumer(direction);
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return !MekanismConfig.current().general.blacklistIC2.val() && this.sideIsOutput(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="ic2")
    public int getStored() {
        return IC2Integration.toEUAsInt(this.getEnergy());
    }

    @Optional.Method(modid="ic2")
    public void setStored(int energy) {
        if (!MekanismConfig.current().general.blacklistIC2.val()) {
            this.setEnergy(IC2Integration.fromEU(energy));
        }
    }

    @Optional.Method(modid="ic2")
    public int getCapacity() {
        return IC2Integration.toEUAsInt(this.getMaxEnergy());
    }

    @Optional.Method(modid="ic2")
    public int getOutput() {
        return IC2Integration.toEUAsInt(this.getMaxOutput());
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return !MekanismConfig.current().general.blacklistIC2.val() ? IC2Integration.toEU(this.getMaxEnergy() - this.getEnergy()) : 0.0;
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return !MekanismConfig.current().general.blacklistIC2.val() ? IC2Integration.toEU(Math.min(this.getEnergy(), this.getMaxOutput())) : 0.0;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return this.sideIsConsumer(side);
    }

    @Optional.Method(modid="ic2")
    public double getOutputEnergyUnitsPerTick() {
        return !MekanismConfig.current().general.blacklistIC2.val() ? IC2Integration.toEU(this.getMaxOutput()) : 0.0;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing pushDirection, double amount, double voltage) {
        TileEntity tile = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(pushDirection.func_176734_d()));
        if (MekanismConfig.current().general.blacklistIC2.val() || CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, pushDirection)) {
            return amount;
        }
        return amount - IC2Integration.toEU(this.acceptEnergy(pushDirection.func_176734_d(), IC2Integration.fromEU(amount), false));
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.setEnergy(Math.max(this.getEnergy() - IC2Integration.fromEU(amount), 0.0));
    }

    @Override
    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        if (toUse < 1.0E-4 || side != null && !this.sideIsConsumer(side)) {
            return 0.0;
        }
        if (!simulate) {
            this.setEnergy(this.getEnergy() + toUse);
        }
        return toUse;
    }

    @Override
    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        double toGive = Math.min(this.getEnergy(), amount);
        if (toGive < 1.0E-4 || side != null && !this.sideIsOutput(side)) {
            return 0.0;
        }
        if (!simulate) {
            this.setEnergy(this.getEnergy() - toGive);
        }
        return toGive;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side) || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (this.isStrictEnergy(capability)) {
            return (T)this;
        }
        if (this.isTesla(capability, side)) {
            return (T)this.getTeslaEnergyWrapper(side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getForgeEnergyWrapper(side));
        }
        return super.getCapability(capability, side);
    }

    protected boolean isStrictEnergy(@Nonnull Capability capability) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY;
    }

    protected boolean isTesla(@Nonnull Capability capability, EnumFacing side) {
        return capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY && this.sideIsConsumer(side) || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.sideIsOutput(side);
    }

    protected ForgeEnergyIntegration getForgeEnergyWrapper(EnumFacing side) {
        return this.forgeEnergyManager.getWrapper(this, side);
    }

    protected TeslaIntegration getTeslaEnergyWrapper(EnumFacing side) {
        return this.teslaManager.getWrapper(this, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            return side != null && !this.sideIsConsumer(side) && !this.sideIsOutput(side);
        }
        return super.isCapabilityDisabled(capability, side);
    }
}

