/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.api.gas.GasStack;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class CommonPlayerTickHandler {
    public static boolean isOnGround(EntityPlayer player) {
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)(player.field_70163_u - 0.01));
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState s = player.field_70170_p.func_180495_p(pos);
        AxisAlignedBB box = s.func_185900_c((IBlockAccess)player.field_70170_p, pos).func_186670_a(pos);
        AxisAlignedBB playerBox = player.func_174813_aQ();
        return !s.func_177230_c().isAir(s, (IBlockAccess)player.field_70170_p, pos) && playerBox.func_72317_d(0.0, -0.01, 0.0).func_72326_a(box);
    }

    public static boolean isGasMaskOn(EntityPlayer player) {
        ItemScubaTank scubaTank;
        ItemStack tank = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack mask = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (!tank.func_190926_b() && !mask.func_190926_b() && tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemGasMask && (scubaTank = (ItemScubaTank)tank.func_77973_b()).getGas(tank) != null) {
            return scubaTank.getFlowing(tank);
        }
        return false;
    }

    public static boolean isFlamethrowerOn(EntityPlayer player) {
        if (Mekanism.playerState.isFlamethrowerOn(player)) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            return !currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower;
        }
        return false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            this.tickEnd(event.player);
        }
    }

    public void tickEnd(EntityPlayer player) {
        ItemStack stack;
        ItemStack feetStack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!feetStack.func_190926_b() && feetStack.func_77973_b() instanceof ItemFreeRunners && !player.func_70093_af()) {
            player.field_70138_W = 1.002f;
        } else if (player.field_70138_W == 1.002f) {
            player.field_70138_W = 0.6f;
        }
        if (CommonPlayerTickHandler.isFlamethrowerOn(player)) {
            player.field_70170_p.func_72838_d((Entity)new EntityFlame(player));
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                ItemStack currentItem = player.field_71071_by.func_70448_g();
                ((ItemFlamethrower)currentItem.func_77973_b()).useGas(currentItem);
            }
        }
        if (this.isJetpackOn(player)) {
            stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();
            ItemJetpack.JetpackMode mode = jetpack.getMode(stack);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                player.field_70181_x = Math.min(player.field_70181_x + 0.15, 0.5);
            } else if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player, KeySync.ASCEND);
                boolean descending = Mekanism.keyMap.has(player, KeySync.DESCEND);
                if (!ascending && !descending || ascending && descending) {
                    if (player.field_70181_x > 0.0) {
                        player.field_70181_x = Math.max(player.field_70181_x - 0.15, 0.0);
                    } else if (player.field_70181_x < 0.0 && !CommonPlayerTickHandler.isOnGround(player)) {
                        player.field_70181_x = Math.min(player.field_70181_x + 0.15, 0.0);
                    }
                } else if (ascending) {
                    player.field_70181_x = Math.min(player.field_70181_x + 0.15, 0.2);
                } else if (!CommonPlayerTickHandler.isOnGround(player)) {
                    player.field_70181_x = Math.max(player.field_70181_x - 0.15, -0.2);
                }
            }
            player.field_70143_R = 0.0f;
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.field_147365_f = 0;
            }
            jetpack.useGas(stack);
        }
        if (CommonPlayerTickHandler.isGasMaskOn(player)) {
            stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemScubaTank tank = (ItemScubaTank)stack.func_77973_b();
            int max = 300;
            tank.useGas(stack);
            GasStack received = tank.useGas(stack, 300 - player.func_70086_ai());
            if (received != null) {
                player.func_70050_g(player.func_70086_ai() + received.amount);
            }
            if (player.func_70086_ai() == 300) {
                for (PotionEffect effect : player.func_70651_bq()) {
                    for (int i = 0; i < 9; ++i) {
                        effect.func_76455_a((EntityLivingBase)player);
                    }
                }
            }
        }
    }

    public boolean isJetpackOn(EntityPlayer player) {
        ItemJetpack jetpack;
        ItemStack chest;
        if (!player.func_184812_l_() && !player.func_175149_v() && !(chest = player.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemJetpack && (jetpack = (ItemJetpack)chest.func_77973_b()).getGas(chest) != null) {
            ItemJetpack.JetpackMode mode = jetpack.getMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return Mekanism.keyMap.has(player, KeySync.ASCEND);
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player, KeySync.ASCEND);
                boolean descending = Mekanism.keyMap.has(player, KeySync.DESCEND);
                if (!ascending || descending) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                return true;
            }
        }
        return false;
    }
}

