/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class LazySideMask {
    byte calc;
    byte result;

    public boolean get(TileEntity parent, EnumFacing side) {
        return this.get(side.ordinal(), parent);
    }

    public boolean isEmpty(TileEntity parent) {
        if (this.calc != 63) {
            for (int i = 0; i < 6; ++i) {
                this.get(i, parent);
            }
        }
        return this.result == 0;
    }

    protected boolean get(int bitIndex, TileEntity parent) {
        int mask = 1 << bitIndex;
        if ((this.calc & mask) == 0) {
            this.calc = (byte)(this.calc | mask);
            this.result = this.test(bitIndex, parent) ? (byte)(this.result | mask) : (byte)(this.result & ~mask);
        }
        return (this.result & mask) != 0;
    }

    protected boolean test(int bitIndex, TileEntity tile) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        EnumFacing facing = EnumFacing.values()[bitIndex];
        BlockPos offset = pos.func_177972_a(facing);
        TileEntity tileEntity = world.func_175625_s(offset);
        return this.test(tileEntity, world, offset, facing.func_176734_d(), tile, bitIndex);
    }

    protected abstract boolean test(@Nullable TileEntity var1, World var2, BlockPos var3, EnumFacing var4, TileEntity var5, int var6);

    public void invalidateAll() {
        this.calc = 0;
    }

    public void invalidate(int bitIndex) {
        this.calc = (byte)(this.calc & 1 << bitIndex);
    }

    public static abstract class HasCap
    extends LazySideMask {
        @Override
        protected boolean test(TileEntity tileEntity, World world, BlockPos offset, EnumFacing opposite, TileEntity tile, int bitIndex) {
            return tileEntity != null && tileEntity.hasCapability(this.getCapability(), opposite);
        }

        protected abstract Capability<?> getCapability();

        public static class Energy
        extends HasCap {
            @Override
            protected Capability<?> getCapability() {
                return CapabilityEnergy.ENERGY;
            }
        }
    }
}

